/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceCache<SeedObject, Instance> {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCache.class);
    Map<SeedObject, Instance> cache = new ConcurrentHashMap<SeedObject, Instance>();

    public Instance retrieve(SeedObject hv) throws AvroSerdeException {
        return this.retrieve(hv, null);
    }

    public Instance retrieve(SeedObject hv, Set<SeedObject> seenSchemas) throws AvroSerdeException {
        LOG.debug("Checking for hv: {}", hv);
        if (this.cache.containsKey(hv)) {
            LOG.debug("Returning cache result");
            return this.cache.get(hv);
        }
        LOG.debug("Creating new instance and storing in cache");
        Instance newInstance = this.makeInstance(hv, seenSchemas);
        Instance cachedInstance = this.cache.putIfAbsent(hv, newInstance);
        return cachedInstance == null ? newInstance : cachedInstance;
    }

    protected abstract Instance makeInstance(SeedObject var1, Set<SeedObject> var2) throws AvroSerdeException;
}

