/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.avro.AvroDeserializer;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.AvroSerializer;
import org.apache.hadoop.hive.serde2.avro.BadSchemaException;
import org.apache.hadoop.hive.serde2.avro.SchemaResolutionProblem;
import org.apache.hadoop.hive.serde2.avro.TypeInfoToSchema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "columns.comments", "name", "comment", "avro.schema.literal", "avro.schema.url", "avro.schema.namespace", "avro.schema.name", "avro.schema.doc"})
public class AvroSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSerDe.class);
    public static final String TABLE_NAME = "name";
    public static final String TABLE_COMMENT = "comment";
    public static final String LIST_COLUMN_COMMENTS = "columns.comments";
    public static final String DECIMAL_TYPE_NAME = "decimal";
    public static final String CHAR_TYPE_NAME = "char";
    public static final String VARCHAR_TYPE_NAME = "varchar";
    public static final String DATE_TYPE_NAME = "date";
    public static final String TIMESTAMP_TYPE_NAME = "timestamp-millis";
    public static final String WRITER_TIME_ZONE = "writer.time.zone";
    public static final String WRITER_PROLEPTIC = "writer.proleptic";
    public static final String WRITER_ZONE_CONVERSION_LEGACY = "writer.zone.conversion.legacy";
    public static final String AVRO_PROP_LOGICAL_TYPE = "logicalType";
    public static final String AVRO_PROP_PRECISION = "precision";
    public static final String AVRO_PROP_SCALE = "scale";
    public static final String AVRO_PROP_MAX_LENGTH = "maxLength";
    public static final String AVRO_STRING_TYPE_NAME = "string";
    public static final String AVRO_INT_TYPE_NAME = "int";
    public static final String AVRO_LONG_TYPE_NAME = "long";
    private ObjectInspector oi;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private Schema schema;
    private AvroDeserializer avroDeserializer = null;
    private AvroSerializer avroSerializer = null;
    private boolean badSchema = false;

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, null);
        if (this.schema != null) {
            LOG.debug("Resetting already initialized AvroSerDe");
        }
        LOG.debug("AvroSerde::initialize(): Preset value of avro.schema.literal == " + tableProperties.get(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()));
        this.schema = null;
        this.oi = null;
        this.columnNames = null;
        this.columnTypes = null;
        String columnNameProperty = tableProperties.getProperty("columns");
        String columnTypeProperty = tableProperties.getProperty("columns.types");
        String columnCommentProperty = tableProperties.getProperty(LIST_COLUMN_COMMENTS, "");
        String columnNameDelimiter = tableProperties.containsKey("column.name.delimiter") ? tableProperties.getProperty("column.name.delimiter") : String.valueOf(',');
        boolean gotColTypesFromColProps = true;
        if (this.hasExternalSchema(tableProperties) || columnNameProperty == null || columnNameProperty.isEmpty() || columnTypeProperty == null || columnTypeProperty.isEmpty()) {
            this.schema = this.determineSchemaOrReturnErrorSchema(configuration, tableProperties);
            gotColTypesFromColProps = false;
        } else {
            this.columnNames = StringInternUtils.internStringsInList(Arrays.asList(columnNameProperty.split(columnNameDelimiter)));
            this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
            this.schema = AvroSerDe.getSchemaFromCols(tableProperties, this.columnNames, this.columnTypes, columnCommentProperty);
        }
        tableProperties.setProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), this.schema.toString());
        LOG.debug("Avro schema is: {}", (Object)this.schema);
        if (this.configuration.isPresent()) {
            ((Configuration)this.configuration.get()).set(AvroSerdeUtils.AvroTableProperties.AVRO_SERDE_SCHEMA.getPropName(), this.schema.toString(false));
        } else {
            LOG.debug("Configuration null, not inserting schema");
        }
        this.badSchema = this.schema == SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        AvroObjectInspectorGenerator aoig = new AvroObjectInspectorGenerator(this.schema);
        this.columnNames = StringInternUtils.internStringsInList(aoig.getColumnNames());
        this.columnTypes = aoig.getColumnTypes();
        this.oi = aoig.getObjectInspector();
        if (!gotColTypesFromColProps) {
            LOG.info("Updating column name/type properties based on current schema");
            tableProperties.setProperty("columns", String.join((CharSequence)",", this.columnNames));
            tableProperties.setProperty("columns.types", String.join((CharSequence)",", TypeInfoUtils.getTypeStringsFromTypeInfo(this.columnTypes)));
        }
        if (this.badSchema) {
            throw new SerDeException("Invalid schema reported");
        }
        this.avroSerializer = new AvroSerializer(configuration);
        this.avroDeserializer = new AvroDeserializer(configuration);
    }

    private boolean hasExternalSchema(Properties properties) {
        return properties.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()) != null || properties.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName()) != null;
    }

    private boolean hasExternalSchema(Map<String, String> tableParams) {
        return tableParams.containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()) || tableParams.containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
    }

    public static Schema getSchemaFromCols(Properties properties, List<String> columnNames, List<TypeInfo> columnTypes, String columnCommentProperty) {
        ArrayList<String> columnComments;
        if (columnCommentProperty == null || columnCommentProperty.isEmpty()) {
            columnComments = new ArrayList();
        } else {
            columnComments = Arrays.asList(columnCommentProperty.split("\u0000"));
            LOG.debug("columnComments is {}", (Object)columnCommentProperty);
        }
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("AvroSerde initialization failed. Number of column name and column type differs. columnNames = " + columnNames + ", columnTypes = " + columnTypes);
        }
        String tableName = properties.getProperty(TABLE_NAME);
        String tableComment = properties.getProperty(TABLE_COMMENT);
        TypeInfoToSchema typeInfoToSchema = new TypeInfoToSchema();
        return typeInfoToSchema.convert(columnNames, columnTypes, columnComments, properties.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_NAMESPACE.getPropName()), properties.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_NAME.getPropName(), tableName), properties.getProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_DOC.getPropName(), tableComment));
    }

    private Schema determineSchemaOrReturnErrorSchema(Configuration conf, Properties props) {
        try {
            return AvroSerdeUtils.determineSchemaOrThrowException(conf, props);
        }
        catch (AvroSerdeException he) {
            LOG.warn("Encountered AvroSerdeException determining schema. Returning signal schema to indicate problem", (Throwable)he);
            return SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        }
        catch (Exception e) {
            LOG.warn("Encountered exception determining schema. Returning signal schema to indicate problem", (Throwable)e);
            return SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        }
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return AvroGenericRecordWritable.class;
    }

    @Override
    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.avroSerializer.serialize(o, objectInspector, this.columnNames, this.columnTypes, this.schema);
    }

    @Override
    public Object deserialize(Writable writable) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.avroDeserializer.deserialize(this.columnNames, this.columnTypes, writable, this.schema);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.oi;
    }

    @Override
    public boolean shouldStoreFieldsInMetastore(Map<String, String> tableParams) {
        return !this.hasExternalSchema(tableParams);
    }
}

