/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;

public class TimestampTZ
implements Comparable<TimestampTZ> {
    private static final ZonedDateTime EPOCH = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    private ZonedDateTime zonedDateTime;

    public TimestampTZ() {
        this(EPOCH);
    }

    public TimestampTZ(ZonedDateTime zonedDateTime) {
        this.setZonedDateTime(zonedDateTime);
    }

    public TimestampTZ(long seconds, int nanos, ZoneId timeZone) {
        this.set(seconds, nanos, timeZone);
    }

    public void set(long seconds, int nanos, ZoneId timeZone) {
        Instant instant = Instant.ofEpochSecond(seconds, nanos);
        this.setZonedDateTime(ZonedDateTime.ofInstant(instant, timeZone));
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public void setZonedDateTime(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime != null ? zonedDateTime : EPOCH;
    }

    public String toString() {
        return this.zonedDateTime.format(TimestampTZUtil.FORMATTER);
    }

    public int hashCode() {
        return this.zonedDateTime.toInstant().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TimestampTZ) {
            TimestampTZ timestamp = (TimestampTZ)other;
            return this.compareTo(timestamp) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(TimestampTZ o) {
        return this.zonedDateTime.toInstant().compareTo(o.zonedDateTime.toInstant());
    }

    public long getEpochSecond() {
        return this.zonedDateTime.toInstant().getEpochSecond();
    }

    public long toEpochMilli() {
        return this.zonedDateTime.toInstant().toEpochMilli();
    }

    public int getNanos() {
        return this.zonedDateTime.toInstant().getNano();
    }

    public Instant toInstant() {
        return this.zonedDateTime.toInstant();
    }
}

