/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.Scope;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;

@InterfaceAudience.Public
public class Vertex {
    private final String vertexName;
    private final ProcessorDescriptor processorDescriptor;
    private int parallelism;
    private VertexLocationHint locationHint;
    private Resource taskResource;
    private final Map<String, LocalResource> taskLocalResources = new HashMap<String, LocalResource>();
    private Map<String, String> taskEnvironment = new HashMap<String, String>();
    private Map<String, String> vertexConf = new HashMap<String, String>();
    private VertexExecutionContext vertexExecutionContext;
    private final Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> additionalInputs = new HashMap<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>>();
    private final Map<String, RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> additionalOutputs = new HashMap<String, RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>>();
    private VertexManagerPluginDescriptor vertexManagerPlugin;
    private final List<Vertex> inputVertices = new ArrayList<Vertex>();
    private final List<Vertex> outputVertices = new ArrayList<Vertex>();
    private final List<Edge> inputEdges = new ArrayList<Edge>();
    private final List<Edge> outputEdges = new ArrayList<Edge>();
    private final Map<String, VertexGroup.GroupInfo> groupInputs = Maps.newHashMap();
    private final List<DataSourceDescriptor> dataSources = Lists.newLinkedList();
    private final List<DataSinkDescriptor> dataSinks = Lists.newLinkedList();
    private String taskLaunchCmdOpts = "";

    @InterfaceAudience.Private
    Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        this(vertexName, processorDescriptor, parallelism, taskResource, false);
    }

    private Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism) {
        this(vertexName, processorDescriptor, parallelism, null, true);
    }

    private Vertex(String vertexName, ProcessorDescriptor processorDescriptor) {
        this(vertexName, processorDescriptor, -1);
    }

    private Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource, boolean allowIncomplete) {
        this.vertexName = vertexName;
        this.processorDescriptor = processorDescriptor;
        this.parallelism = parallelism;
        this.taskResource = taskResource;
        if (parallelism < -1) {
            throw new IllegalArgumentException("Parallelism should be -1 if determined by the AM, otherwise should be >= 0");
        }
        if (!allowIncomplete && taskResource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
    }

    public static Vertex create(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        return new Vertex(vertexName, processorDescriptor, parallelism, taskResource);
    }

    public static Vertex create(String vertexName, ProcessorDescriptor processorDescriptor) {
        return new Vertex(vertexName, processorDescriptor);
    }

    public static Vertex create(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism) {
        return new Vertex(vertexName, processorDescriptor, parallelism);
    }

    public String getName() {
        return this.vertexName;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public Resource getTaskResource() {
        return this.taskResource;
    }

    public Vertex setLocationHint(VertexLocationHint locationHint) {
        List<TaskLocationHint> locations = locationHint.getTaskLocationHints();
        if (locations == null) {
            return this;
        }
        Preconditions.checkArgument(locations.size() == this.parallelism, "Locations array length must match the parallelism set for the vertex");
        this.locationHint = locationHint;
        return this;
    }

    VertexLocationHint getLocationHint() {
        return this.locationHint;
    }

    public Vertex addTaskLocalFiles(Map<String, LocalResource> localFiles) {
        if (localFiles != null) {
            TezCommonUtils.addAdditionalLocalResources(localFiles, this.taskLocalResources, "Vertex " + this.getName());
        }
        return this;
    }

    public Map<String, LocalResource> getTaskLocalFiles() {
        return this.taskLocalResources;
    }

    public Vertex setTaskEnvironment(Map<String, String> environment) {
        this.taskEnvironment.putAll(Objects.requireNonNull(environment));
        return this;
    }

    public Map<String, String> getTaskEnvironment() {
        return this.taskEnvironment;
    }

    public Map<String, String> getConf() {
        return this.vertexConf;
    }

    public Vertex setTaskLaunchCmdOpts(String cmdOpts) {
        this.taskLaunchCmdOpts = cmdOpts;
        return this;
    }

    public Vertex addDataSource(String inputName, DataSourceDescriptor dataSourceDescriptor) {
        Preconditions.checkArgument(StringUtils.isNotBlank((String)inputName), "InputName should not be null, empty or white space only, inputName=" + inputName);
        Preconditions.checkArgument(!this.additionalInputs.containsKey(inputName), "Duplicated input:" + inputName + ", vertexName=" + this.vertexName);
        this.additionalInputs.put(inputName, new RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>(inputName, dataSourceDescriptor.getInputDescriptor(), dataSourceDescriptor.getInputInitializerDescriptor()));
        this.dataSources.add(dataSourceDescriptor);
        return this;
    }

    public Vertex addDataSink(String outputName, DataSinkDescriptor dataSinkDescriptor) {
        Preconditions.checkArgument(StringUtils.isNotBlank((String)outputName), "OutputName should not be null, empty or white space only, outputName=" + outputName);
        Preconditions.checkArgument(!this.additionalOutputs.containsKey(outputName), "Duplicated output:" + outputName + ", vertexName=" + this.vertexName);
        this.additionalOutputs.put(outputName, new RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>(outputName, dataSinkDescriptor.getOutputDescriptor(), dataSinkDescriptor.getOutputCommitterDescriptor()));
        this.dataSinks.add(dataSinkDescriptor);
        return this;
    }

    Vertex addAdditionalDataSink(RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> output) {
        Preconditions.checkArgument(StringUtils.isNotBlank((String)output.getName()), "OutputName should not be null, empty or white space only, outputName=" + output.getName());
        Preconditions.checkArgument(!this.additionalOutputs.containsKey(output.getName()), "Duplicated output:" + output.getName() + ", vertexName=" + this.vertexName);
        this.additionalOutputs.put(output.getName(), output);
        return this;
    }

    public Vertex setVertexManagerPlugin(VertexManagerPluginDescriptor vertexManagerPluginDescriptor) {
        this.vertexManagerPlugin = vertexManagerPluginDescriptor;
        return this;
    }

    public String getTaskLaunchCmdOpts() {
        return this.taskLaunchCmdOpts;
    }

    @InterfaceStability.Unstable
    public Vertex setConf(String property, String value) {
        TezConfiguration.validateProperty(property, Scope.VERTEX);
        this.vertexConf.put(property, value);
        return this;
    }

    public Vertex setExecutionContext(VertexExecutionContext vertexExecutionContext) {
        this.vertexExecutionContext = vertexExecutionContext;
        return this;
    }

    public String toString() {
        return "[" + this.vertexName + " : " + this.processorDescriptor.getClassName() + "]";
    }

    VertexManagerPluginDescriptor getVertexManagerPlugin() {
        return this.vertexManagerPlugin;
    }

    Map<String, VertexGroup.GroupInfo> getGroupInputs() {
        return this.groupInputs;
    }

    void addGroupInput(String groupName, VertexGroup.GroupInfo groupInputInfo) {
        if (this.groupInputs.put(groupName, groupInputInfo) != null) {
            throw new IllegalStateException("Vertex: " + this.getName() + " already has group input with name:" + groupName);
        }
    }

    void addInputVertex(Vertex inputVertex, Edge edge) {
        this.inputVertices.add(inputVertex);
        this.inputEdges.add(edge);
    }

    void addOutputVertex(Vertex outputVertex, Edge edge) {
        this.outputVertices.add(outputVertex);
        this.outputEdges.add(edge);
    }

    public List<Vertex> getInputVertices() {
        return Collections.unmodifiableList(this.inputVertices);
    }

    public List<Vertex> getOutputVertices() {
        return Collections.unmodifiableList(this.outputVertices);
    }

    void setTaskResource(Resource resource) {
        this.taskResource = resource;
    }

    @InterfaceAudience.Private
    public List<DataSourceDescriptor> getDataSources() {
        return this.dataSources;
    }

    @InterfaceAudience.Private
    public List<DataSinkDescriptor> getDataSinks() {
        return this.dataSinks;
    }

    @InterfaceAudience.Private
    public VertexExecutionContext getVertexExecutionContext() {
        return this.vertexExecutionContext;
    }

    List<Edge> getInputEdges() {
        return this.inputEdges;
    }

    List<Edge> getOutputEdges() {
        return this.outputEdges;
    }

    List<RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> getInputs() {
        return Lists.newArrayList(this.additionalInputs.values());
    }

    List<RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> getOutputs() {
        return Lists.newArrayList(this.additionalOutputs.values());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vertexName == null ? 0 : this.vertexName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return !(this.vertexName == null ? other.vertexName != null : !this.vertexName.equals(other.vertexName));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class VertexExecutionContext {
        final boolean executeInAm;
        final boolean executeInContainers;
        final String taskSchedulerName;
        final String containerLauncherName;
        final String taskCommName;

        public static VertexExecutionContext createExecuteInAm(boolean executeInAm) {
            return new VertexExecutionContext(executeInAm, false);
        }

        public static VertexExecutionContext createExecuteInContainers(boolean executeInContainers) {
            return new VertexExecutionContext(false, executeInContainers);
        }

        public static VertexExecutionContext create(String taskSchedulerName, String containerLauncherName, String taskCommName) {
            return new VertexExecutionContext(taskSchedulerName, containerLauncherName, taskCommName);
        }

        private VertexExecutionContext(boolean executeInAm, boolean executeInContainers) {
            this(executeInAm, executeInContainers, null, null, null);
        }

        private VertexExecutionContext(String taskSchedulerName, String containerLauncherName, String taskCommName) {
            this(false, false, taskSchedulerName, containerLauncherName, taskCommName);
        }

        private VertexExecutionContext(boolean executeInAm, boolean executeInContainers, String taskSchedulerName, String containerLauncherName, String taskCommName) {
            if (executeInAm || executeInContainers) {
                Preconditions.checkState(!executeInAm || !executeInContainers, "executeInContainers and executeInAM are mutually exclusive");
                Preconditions.checkState(taskSchedulerName == null && containerLauncherName == null && taskCommName == null, "Uber (in-AM) or container execution cannot be enabled with a custom plugins. TaskScheduler=" + taskSchedulerName + ", ContainerLauncher=" + containerLauncherName + ", TaskCommunicator=" + taskCommName);
            }
            if (taskSchedulerName != null || containerLauncherName != null || taskCommName != null) {
                Preconditions.checkState(!executeInAm && !executeInContainers, "Uber (in-AM) and container execution cannot be enabled with a custom plugins. TaskScheduler=" + taskSchedulerName + ", ContainerLauncher=" + containerLauncherName + ", TaskCommunicator=" + taskCommName);
            }
            this.executeInAm = executeInAm;
            this.executeInContainers = executeInContainers;
            this.taskSchedulerName = taskSchedulerName;
            this.containerLauncherName = containerLauncherName;
            this.taskCommName = taskCommName;
        }

        public boolean shouldExecuteInAm() {
            return this.executeInAm;
        }

        public boolean shouldExecuteInContainers() {
            return this.executeInContainers;
        }

        public String getTaskSchedulerName() {
            return this.taskSchedulerName;
        }

        public String getContainerLauncherName() {
            return this.containerLauncherName;
        }

        public String getTaskCommName() {
            return this.taskCommName;
        }

        public String toString() {
            return "VertexExecutionContext{executeInAm=" + this.executeInAm + ", executeInContainers=" + this.executeInContainers + ", taskSchedulerName='" + this.taskSchedulerName + '\'' + ", containerLauncherName='" + this.containerLauncherName + '\'' + ", taskCommName='" + this.taskCommName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexExecutionContext that = (VertexExecutionContext)o;
            if (this.executeInAm != that.executeInAm) {
                return false;
            }
            if (this.executeInContainers != that.executeInContainers) {
                return false;
            }
            if (this.taskSchedulerName != null ? !this.taskSchedulerName.equals(that.taskSchedulerName) : that.taskSchedulerName != null) {
                return false;
            }
            if (this.containerLauncherName != null ? !this.containerLauncherName.equals(that.containerLauncherName) : that.containerLauncherName != null) {
                return false;
            }
            return !(this.taskCommName == null ? that.taskCommName != null : !this.taskCommName.equals(that.taskCommName));
        }

        public int hashCode() {
            int result = this.executeInAm ? 1 : 0;
            result = 31 * result + (this.executeInContainers ? 1 : 0);
            result = 31 * result + (this.taskSchedulerName != null ? this.taskSchedulerName.hashCode() : 0);
            result = 31 * result + (this.containerLauncherName != null ? this.containerLauncherName.hashCode() : 0);
            result = 31 * result + (this.taskCommName != null ? this.taskCommName.hashCode() : 0);
            return result;
        }
    }
}

