/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class CaseNumericExpression
extends NumericExpression {
    public CaseNumericExpression(SQLExpression[] whenExprs, SQLExpression[] actionExprs, SQLExpression elseExpr) {
        super(whenExprs[0].getSQLStatement(), (SQLTable)null, (JavaTypeMapping)null);
        this.st.clearStatement();
        this.st.append("CASE");
        if (actionExprs == null || whenExprs.length != actionExprs.length || whenExprs.length == 0) {
            throw new IllegalArgumentException("CaseExpression must have equal number of WHEN and THEN expressions");
        }
        this.mapping = actionExprs[0].getJavaTypeMapping();
        for (int i = 0; i < whenExprs.length; ++i) {
            SQLExpression actionExpr = actionExprs[i];
            if (actionExpr instanceof ParameterLiteral) {
                ParameterLiteral paramLit = (ParameterLiteral)actionExpr;
                actionExpr = this.stmt.getSQLExpressionFactory().newLiteralParameter(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Number.class), paramLit.getValue(), paramLit.getParameterName());
            }
            this.st.append(" WHEN ").append(whenExprs[i]).append(" THEN ").append(actionExpr);
        }
        if (elseExpr != null) {
            SQLExpression actionExpr = elseExpr;
            if (actionExpr instanceof ParameterLiteral) {
                ParameterLiteral paramLit = (ParameterLiteral)actionExpr;
                actionExpr = this.stmt.getSQLExpressionFactory().newLiteralParameter(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Number.class), paramLit.getValue(), paramLit.getParameterName());
            }
            this.st.append(" ELSE ").append(actionExpr);
        }
        this.st.append(" END");
        this.st.encloseInParentheses();
    }
}

