/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.util.UUID;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class UUIDObjectGenerator
extends AbstractGenerator<UUID> {
    public UUIDObjectGenerator(StoreManager storeMgr, String name) {
        super(storeMgr, name);
    }

    public static Class getStorageClass() {
        return UUID.class;
    }

    @Override
    protected ValueGenerationBlock reserveBlock(long size) {
        Object[] ids = new Object[(int)size];
        int i = 0;
        while ((long)i < size) {
            ids[i] = UUID.randomUUID();
            ++i;
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(Localiser.msg("040004", "" + size));
        }
        return new ValueGenerationBlock<Object>(ids);
    }
}

