/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.DateTimeException;
import java.time.ZoneId;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class ZoneIdStringConverter
implements TypeConverter<ZoneId, String> {
    private static final long serialVersionUID = -6952772783848336885L;

    @Override
    public ZoneId toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return ZoneId.of(str);
        }
        catch (DateTimeException dte) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, ZoneId.class.getName()), dte);
        }
    }

    @Override
    public String toDatastoreType(ZoneId zone) {
        return zone != null ? zone.toString() : null;
    }
}

