/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;

public class BigDecimalArrayByteBufferConverter
implements TypeConverter<BigDecimal[], ByteBuffer> {
    private static final long serialVersionUID = 5829673311829818607L;

    @Override
    public ByteBuffer toDatastoreType(BigDecimal[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = ArrayConversionHelper.getByteArrayFromBigDecimalArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public BigDecimal[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return ArrayConversionHelper.getBigDecimalArrayFromByteArray(datastoreValue.array());
    }
}

