/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;

public class RoundFunction
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object ignored, InMemoryExpressionEvaluator eval) {
        List<Expression> args = expr.getArguments();
        if (args == null || args.isEmpty()) {
            throw new NucleusException("ROUND requires two arguments");
        }
        if (args.size() == 1) {
            return this.getValueForArgExpression(args.get(0), eval);
        }
        Expression argExpr1 = args.get(0);
        Object argValue1 = this.getValueForArgExpression(argExpr1, eval);
        Double dblValue = (Double)argValue1;
        Expression argExpr2 = args.get(1);
        Object argValue2 = this.getValueForArgExpression(argExpr2, eval);
        Integer decs = (Integer)argValue2;
        return (double)Math.round(dblValue * Math.pow(10.0, decs.intValue())) / Math.pow(10.0, decs.intValue());
    }

    protected Object getValueForArgExpression(Expression argExpr, InMemoryExpressionEvaluator eval) {
        Object argValue = null;
        if (argExpr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)argExpr;
            argValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (argExpr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)argExpr;
            argValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (argExpr instanceof Literal) {
            argValue = ((Literal)argExpr).getLiteral();
        } else {
            throw new NucleusException("Don't support ROUND with argument of type " + argExpr.getClass().getName());
        }
        return argValue;
    }
}

