/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class SoftDeleteMetaData
extends MetaData {
    private static final long serialVersionUID = 1526198088851283681L;
    protected String columnName = null;
    protected ColumnMetaData columnMetaData = null;
    protected Boolean indexed = null;
    protected IndexMetaData indexMetaData;

    public SoftDeleteMetaData() {
    }

    public SoftDeleteMetaData(SoftDeleteMetaData sdmd) {
        super(null, sdmd);
        this.columnName = sdmd.columnName;
        this.indexed = sdmd.indexed;
        if (sdmd.columnMetaData != null) {
            this.setColumnMetaData(new ColumnMetaData(sdmd.columnMetaData));
        }
        if (sdmd.indexMetaData != null) {
            this.setIndexMetaData(new IndexMetaData(sdmd.indexMetaData));
        }
    }

    @Override
    public void initialise(ClassLoaderResolver clr) {
        if (this.indexMetaData == null && this.indexed == Boolean.TRUE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(false);
            if (this.columnMetaData != null) {
                this.indexMetaData.addColumn(this.columnMetaData.getName());
            }
            this.indexMetaData.parent = this;
        }
        this.setInitialised();
    }

    public String getColumnName() {
        if (this.columnMetaData != null && this.columnMetaData.getName() != null) {
            return this.columnMetaData.getName();
        }
        return this.columnName;
    }

    public SoftDeleteMetaData setColumnName(String columnName) {
        if (!StringUtils.isWhitespace(columnName)) {
            if (this.columnMetaData == null) {
                this.columnMetaData = new ColumnMetaData();
                this.columnMetaData.setName(columnName);
                this.columnMetaData.parent = this;
            } else {
                this.columnMetaData.setName(columnName);
            }
            this.columnName = columnName;
        } else {
            this.columnName = null;
        }
        return this;
    }

    public ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        colmd.setJdbcType(JdbcType.BOOLEAN);
        if (this.columnName != null) {
            colmd.setName(this.columnName);
        }
        this.setColumnMetaData(colmd);
        return colmd;
    }

    public void setColumnMetaData(ColumnMetaData columnMetaData) {
        this.columnMetaData = columnMetaData;
        this.columnMetaData.parent = this;
    }

    public SoftDeleteMetaData setIndexed(boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        this.indexMetaData.parent = this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("SoftDeleteMetaData[");
        if (this.columnName != null) {
            str.append("columnName=").append(this.columnName);
        }
        if (this.columnMetaData != null) {
            str.append(", column=").append(this.columnMetaData);
        }
        if (this.indexed != null) {
            str.append(", indexed=").append(this.indexed);
        }
        str.append("]");
        return str.toString();
    }
}

