/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CompactionCandidateHandler
implements QueryHandler<Set<CompactionInfo>> {
    private final long checkInterval;
    private final int fetchSize;

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return databaseProduct.addLimitClause(this.fetchSize, "DISTINCT \"TC\".\"CTC_DATABASE\", \"TC\".\"CTC_TABLE\", \"TC\".\"CTC_PARTITION\" FROM \"COMPLETED_TXN_COMPONENTS\" \"TC\" " + (String)(this.checkInterval > 0L ? "LEFT JOIN (   SELECT \"C1\".* FROM \"COMPLETED_COMPACTIONS\" \"C1\"   INNER JOIN (     SELECT MAX(\"CC_ID\") \"CC_ID\" FROM \"COMPLETED_COMPACTIONS\"     GROUP BY \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\"  ) \"C2\"   ON \"C1\".\"CC_ID\" = \"C2\".\"CC_ID\"   WHERE \"C1\".\"CC_STATE\" IN (:didNotInit, :failed)) \"C\" ON \"TC\".\"CTC_DATABASE\" = \"C\".\"CC_DATABASE\" AND \"TC\".\"CTC_TABLE\" = \"C\".\"CC_TABLE\"   AND (\"TC\".\"CTC_PARTITION\" = \"C\".\"CC_PARTITION\" OR (\"TC\".\"CTC_PARTITION\" IS NULL AND \"C\".\"CC_PARTITION\" IS NULL)) WHERE \"C\".\"CC_ID\" IS NOT NULL OR " + databaseProduct.isWithinCheckInterval("\"TC\".\"CTC_TIMESTAMP\"", this.checkInterval) : ""));
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("didNotInit", (Object)Character.toString('a'), 1).addValue("failed", (Object)Character.toString('f'), 1);
    }

    public Set<CompactionInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        while (rs.next()) {
            CompactionInfo candidate = new CompactionInfo();
            candidate.dbname = rs.getString(1);
            candidate.tableName = rs.getString(2);
            candidate.partName = rs.getString(3);
            response.add(candidate);
        }
        return response;
    }

    public CompactionCandidateHandler(long lastChecked, int fetchSize) {
        this.checkInterval = lastChecked <= 0L ? lastChecked : (System.currentTimeMillis() - lastChecked + 500L) / 1000L;
        this.fetchSize = fetchSize;
    }
}

