/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;

public class JSONCommitTxnMessage
extends CommitTxnMessage {
    @JsonProperty
    private Long txnid;
    @JsonProperty
    private Long timestamp;
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;
    @JsonProperty
    private List<Long> writeIds;
    @JsonProperty
    private List<String> databases;
    @JsonProperty
    private List<String> tables;
    @JsonProperty
    private List<String> partitions;
    @JsonProperty
    private List<String> tableObjs;
    @JsonProperty
    private List<String> partitionObjs;
    @JsonProperty
    private List<String> files;

    public JSONCommitTxnMessage() {
    }

    public JSONCommitTxnMessage(String server, String servicePrincipal, Long txnid, Long timestamp) {
        this.timestamp = timestamp;
        this.txnid = txnid;
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.databases = null;
        this.tables = null;
        this.writeIds = null;
        this.partitions = null;
        this.tableObjs = null;
        this.partitionObjs = null;
        this.files = null;
    }

    public JSONCommitTxnMessage(String server, String servicePrincipal, Long txnid, Long timestamp, List<String> databases, List<Long> writeIds) {
        this(server, servicePrincipal, txnid, timestamp);
        this.databases = databases;
        this.writeIds = writeIds;
    }

    @Override
    public Long getTxnId() {
        return this.txnid;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public List<Long> getWriteIds() {
        return this.writeIds;
    }

    @Override
    public List<String> getDatabases() {
        return this.databases;
    }

    @Override
    public List<String> getTables() {
        return this.tables;
    }

    @Override
    public List<String> getPartitions() {
        return this.partitions;
    }

    @Override
    public Table getTableObj(int idx) throws Exception {
        return this.tableObjs == null ? null : (Table)MessageBuilder.getTObj(this.tableObjs.get(idx), Table.class);
    }

    @Override
    public Partition getPartitionObj(int idx) throws Exception {
        return this.partitionObjs == null ? null : (this.partitionObjs.get(idx) == null ? null : (Partition)MessageBuilder.getTObj(this.partitionObjs.get(idx), Partition.class));
    }

    @Override
    public String getFiles(int idx) {
        return this.files == null ? null : this.files.get(idx);
    }

    @Override
    public List<String> getFilesList() {
        return this.files;
    }

    @Override
    public void addWriteEventInfo(List<WriteEventInfo> writeEventInfoList) {
        if (this.databases == null) {
            this.databases = Lists.newArrayList();
        }
        if (this.tables == null) {
            this.tables = Lists.newArrayList();
        }
        if (this.writeIds == null) {
            this.writeIds = Lists.newArrayList();
        }
        if (this.tableObjs == null) {
            this.tableObjs = Lists.newArrayList();
        }
        if (this.partitions == null) {
            this.partitions = Lists.newArrayList();
        }
        if (this.partitionObjs == null) {
            this.partitionObjs = Lists.newArrayList();
        }
        if (this.files == null) {
            this.files = Lists.newArrayList();
        }
        for (WriteEventInfo writeEventInfo : writeEventInfoList) {
            this.databases.add(writeEventInfo.getDatabase());
            this.tables.add(writeEventInfo.getTable());
            this.writeIds.add(writeEventInfo.getWriteId());
            this.partitions.add(writeEventInfo.getPartition());
            this.tableObjs.add(writeEventInfo.getTableObj());
            this.partitionObjs.add(writeEventInfo.getPartitionObj());
            this.files.add(writeEventInfo.getFiles());
        }
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

