/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueueMonitor
extends DynamicMBeanProvider {
    private static final String MBEAN_DESCRIPTION = "Message Queue Monitor";
    private static final Logger LOG = LoggerFactory.getLogger(MessageQueueMonitor.class);
    private final String _clusterName;
    private final String _instanceName;
    private final MBeanServer _beanServer;
    private SimpleDynamicMetric<Long> _messageQueueBacklog;

    public MessageQueueMonitor(String clusterName, String instanceName) {
        this._clusterName = clusterName;
        this._instanceName = instanceName;
        this._beanServer = ManagementFactory.getPlatformMBeanServer();
        this._messageQueueBacklog = new SimpleDynamicMetric<Long>("MessageQueueBacklog", 0L);
    }

    public void setMessageQueueBacklog(long size) {
        this._messageQueueBacklog.updateValue(size);
    }

    public void init() {
        try {
            this.register();
        }
        catch (Exception e) {
            LOG.error("Fail to register MessageQueueMonitor", (Throwable)e);
        }
    }

    public void reset() {
        this._messageQueueBacklog.updateValue(0L);
        try {
            this.unregister();
        }
        catch (Exception e) {
            LOG.error("Fail to register MessageQueueMonitor", (Throwable)e);
        }
    }

    @Override
    public String getSensorName() {
        return "MessageQueueStatus." + this._clusterName;
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._messageQueueBacklog);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, this.getObjectName(this.getBeanName()));
        return this;
    }

    private String getClusterBeanName() {
        return String.format("%s=%s", "cluster", this._clusterName);
    }

    private String getBeanName() {
        return String.format("%s,%s=%s", this.getClusterBeanName(), "messageQueue", this._instanceName);
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:%s", MonitorDomainNames.ClusterStatus.name(), name));
    }
}

