/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReportRegionStateTransitionRetry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReportRegionStateTransitionRetry.class);
    private static final AtomicReference<CountDownLatch> RESUME_AND_FAIL = new AtomicReference();
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Retry");
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(1);
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRetryOnClose() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
        CountDownLatch latch = new CountDownLatch(1);
        RESUME_AND_FAIL.set(latch);
        Future future = am.moveAsync(new RegionPlan(region, rsn.getRegionLocation(), rsn.getRegionLocation()));
        TransitRegionStateProcedure proc = procExec.getProcedures().stream().filter(p -> p instanceof TransitRegionStateProcedure).filter(p -> !p.isFinished()).map(p -> (TransitRegionStateProcedure)p).findAny().get();
        UTIL.waitFor(10000L, () -> proc.getCurrentStateId() == 3);
        latch.countDown();
        future.get();
        try (Table table = UTIL.getConnection().getTableBuilder(NAME, null).setWriteRpcTimeout(1000).setOperationTimeout(2000).build();){
            table.put(new Put(Bytes.toBytes((String)"key")).addColumn(CF, Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"val")));
        }
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master, MasterRegion masterRegion) {
            return new AssignmentManagerForTest(master, masterRegion);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            RegionServerStatusProtos.ReportRegionStateTransitionResponse resp = super.reportRegionStateTransition(req);
            CountDownLatch latch = RESUME_AND_FAIL.getAndSet(null);
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                throw new PleaseHoldException("Inject error");
            }
            return resp;
        }
    }
}

