/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.modifyDnRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestEntryName
extends GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestEntryName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyDnRequestEntryName() {
        super("Store ModifyDN request entry Name");
    }

    @Override
    public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn entry = null;
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err(I18n.ERR_04089, new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString(dnBytes);
        try {
            entry = new Dn(dnStr);
        }
        catch (LdapInvalidDnException ine) {
            String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes(dnBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        modifyDnRequest.setName(entry);
        if (IS_DEBUG) {
            LOG.debug("Modifying Dn {}", (Object)entry);
        }
    }
}

