/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatencies;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatenciesImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerTableMetrics;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsTableLatencies {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsTableLatencies.class);
    public static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testTableWrapperAggregateMetrics() throws IOException {
        TableName tn1 = TableName.valueOf((String)"table1");
        TableName tn2 = TableName.valueOf((String)"table2");
        MetricsTableLatencies latencies = (MetricsTableLatencies)CompatibilitySingletonFactory.getInstance(MetricsTableLatencies.class);
        Assert.assertTrue((String)("'latencies' is actually " + latencies.getClass()), (boolean)(latencies instanceof MetricsTableLatenciesImpl));
        MetricsTableLatenciesImpl latenciesImpl = (MetricsTableLatenciesImpl)latencies;
        RegionServerTableMetrics tableMetrics = new RegionServerTableMetrics(false);
        tableMetrics.updateGet(tn1, 500L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"getTime_999th_percentile"), 500L, (BaseSource)latenciesImpl);
        tableMetrics.updatePut(tn1, 50L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"putTime_99th_percentile"), 50L, (BaseSource)latenciesImpl);
        tableMetrics.updateGet(tn2, 300L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn2, (String)"getTime_999th_percentile"), 300L, (BaseSource)latenciesImpl);
        tableMetrics.updatePut(tn2, 75L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn2, (String)"putTime_99th_percentile"), 75L, (BaseSource)latenciesImpl);
    }

    @Test
    public void testTableQueryMeterSwitch() {
        TableName tn1 = TableName.valueOf((String)"table1");
        MetricsTableLatencies latencies = (MetricsTableLatencies)CompatibilitySingletonFactory.getInstance(MetricsTableLatencies.class);
        Assert.assertTrue((String)("'latencies' is actually " + latencies.getClass()), (boolean)(latencies instanceof MetricsTableLatenciesImpl));
        MetricsTableLatenciesImpl latenciesImpl = (MetricsTableLatenciesImpl)latencies;
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.regionserver.enable.table.query.meter", false);
        boolean enableTableQueryMeter = conf.getBoolean("hbase.regionserver.enable.table.query.meter", true);
        Assert.assertFalse((boolean)enableTableQueryMeter);
        RegionServerTableMetrics tableMetrics = new RegionServerTableMetrics(enableTableQueryMeter);
        tableMetrics.updateTableReadQueryMeter(tn1, 500L);
        Assert.assertFalse((boolean)HELPER.checkGaugeExists(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"tableReadQueryPerSecond_count"), (BaseSource)latenciesImpl));
        tableMetrics.updateTableWriteQueryMeter(tn1, 500L);
        Assert.assertFalse((boolean)HELPER.checkGaugeExists(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"tableWriteQueryPerSecond_count"), (BaseSource)latenciesImpl));
        conf.setBoolean("hbase.regionserver.enable.table.query.meter", true);
        enableTableQueryMeter = conf.getBoolean("hbase.regionserver.enable.table.query.meter", true);
        Assert.assertTrue((boolean)enableTableQueryMeter);
        tableMetrics = new RegionServerTableMetrics(true);
        tableMetrics.updateTableReadQueryMeter(tn1, 500L);
        Assert.assertTrue((boolean)HELPER.checkGaugeExists(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"tableReadQueryPerSecond_count"), (BaseSource)latenciesImpl));
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"tableReadQueryPerSecond_count"), 500L, (BaseSource)latenciesImpl);
        tableMetrics.updateTableWriteQueryMeter(tn1, 500L);
        Assert.assertTrue((boolean)HELPER.checkGaugeExists(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"tableWriteQueryPerSecond_count"), (BaseSource)latenciesImpl));
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName((TableName)tn1, (String)"tableWriteQueryPerSecond_count"), 500L, (BaseSource)latenciesImpl);
    }
}

