/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.TimeBasedLimiter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDefaultOperationQuota {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultOperationQuota.class);
    private static final int DEFAULT_REQUESTS_PER_SECOND = 1000;
    private static ManualEnvironmentEdge envEdge = new ManualEnvironmentEdge();

    @Test
    public void testScanEstimateNewScanner() {
        long blockSize = 65536L;
        long nextCallSeq = 0L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 0L;
        long prevBBSDifference = 0L;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)blockSize, (long)estimate);
    }

    @Test
    public void testScanEstimateSecondNextCall() {
        long blockSize = 65536L;
        long nextCallSeq = 1L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 10L * blockSize;
        long prevBBSDifference = 10L * blockSize;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
    }

    @Test
    public void testScanEstimateFlatWorkload() {
        long blockSize = 65536L;
        long nextCallSeq = 100L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 10L * blockSize;
        long prevBBSDifference = 0L;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
    }

    @Test
    public void testScanEstimateVariableFlatWorkload() {
        long blockSize = 65536L;
        long nextCallSeq = 1L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 10L * blockSize;
        long prevBBSDifference = 0L;
        for (int i = 0; i < 100; ++i) {
            long variation = Math.round(Math.random() * (double)blockSize);
            if (variation % 2L == 0L) {
                variation *= -1L;
            }
            prevBBSDifference = variation;
            long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)(nextCallSeq + (long)i), (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
            Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
        }
    }

    @Test
    public void testScanEstimateGrowingWorkload() {
        long nextCallSeq = 100L;
        long blockSize = 65536L;
        long maxBlockBytesScanned = 20L * blockSize;
        long maxScannerResultSize = 0x6400000L;
        long prevBBSDifference = 10L * blockSize;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertTrue((nextCallSeq * maxBlockBytesScanned == estimate || maxScannerResultSize == estimate ? 1 : 0) != 0);
    }

    @Test
    public void testScanEstimateShrinkingWorkload() {
        long blockSize = 65536L;
        long nextCallSeq = 100L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 20L * blockSize;
        long prevBBSDifference = -10L * blockSize;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
    }

    @Test
    public void testLargeBatchSaturatesReadNumLimit() throws RpcThrottlingException, InterruptedException {
        int limit = 10;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setReadNum(QuotaProtos.TimedQuota.newBuilder().setSoftLimit((long)limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), 65536, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(0, limit, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(0, 1, false));
        envEdge.incValue(1000L);
        quota.checkBatchQuota(0, limit, false);
    }

    @Test
    public void testLargeBatchSaturatesReadWriteLimit() throws RpcThrottlingException, InterruptedException {
        int limit = 10;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setWriteNum(QuotaProtos.TimedQuota.newBuilder().setSoftLimit((long)limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), 65536, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(limit, 0, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(1, 0, false));
        envEdge.incValue(1000L);
        quota.checkBatchQuota(limit, 0, false);
    }

    @Test
    public void testTooLargeReadBatchIsNotBlocked() throws RpcThrottlingException, InterruptedException {
        int limit = 10;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setReadNum(QuotaProtos.TimedQuota.newBuilder().setSoftLimit((long)limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), 65536, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(0, 10 + limit, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(0, 1, false));
        envEdge.incValue(1000L);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(0, limit, false));
    }

    @Test
    public void testTooLargeWriteBatchIsNotBlocked() throws RpcThrottlingException, InterruptedException {
        int limit = 10;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setWriteNum(QuotaProtos.TimedQuota.newBuilder().setSoftLimit((long)limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), 65536, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(10 + limit, 0, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(1, 0, false));
        envEdge.incValue(1000L);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(limit, 0, false));
    }

    @Test
    public void testTooLargeWriteSizeIsNotBlocked() throws RpcThrottlingException, InterruptedException {
        int limit = 50;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setWriteSize(QuotaProtos.TimedQuota.newBuilder().setSoftLimit((long)limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), 65536, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(1, 0, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(1, 0, false));
        envEdge.incValue(1000L);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(limit, 0, false));
    }

    @Test
    public void testTooLargeReadSizeIsNotBlocked() throws RpcThrottlingException, InterruptedException {
        long blockSize = 65536L;
        long limit = blockSize / 2L;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setSoftLimit(limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), (int)blockSize, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(0, 1, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(0, 1, false));
        envEdge.incValue(1000L);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota((int)limit, 1, false));
    }

    @Test
    public void testTooLargeRequestSizeIsNotBlocked() throws RpcThrottlingException, InterruptedException {
        long blockSize = 65536L;
        long limit = blockSize / 2L;
        QuotaProtos.Throttle throttle = QuotaProtos.Throttle.newBuilder().setReqSize(QuotaProtos.TimedQuota.newBuilder().setSoftLimit(limit).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build()).build();
        QuotaLimiter limiter = TimeBasedLimiter.fromThrottle((QuotaProtos.Throttle)throttle);
        DefaultOperationQuota quota = new DefaultOperationQuota(new Configuration(), (int)blockSize, 1000.0, new QuotaLimiter[]{limiter});
        quota.checkBatchQuota(0, 1, false);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota(0, 1, false));
        envEdge.incValue(1000L);
        Assert.assertThrows(RpcThrottlingException.class, () -> quota.checkBatchQuota((int)limit, 1, false));
    }

    static {
        envEdge.setValue(EnvironmentEdgeManager.currentTime());
        EnvironmentEdgeManagerTestHelper.injectEdgeForPackage((EnvironmentEdge)envEdge, (String)ThrottleQuotaTestUtil.class.getPackage().getName());
    }
}

