/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, CoprocessorTests.class})
public class TestRegionCoprocessorQuotaUsage {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionCoprocessorQuotaUsage.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"TestRegionCoprocessorQuotaUsage");
    private static byte[] CF = Bytes.toBytes((String)"CF");
    private static byte[] CQ = Bytes.toBytes((String)"CQ");
    private static Connection CONN;
    private static Table TABLE;
    private static AtomicBoolean THROTTLING_OCCURRED;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.quota.enabled", true);
        conf.setInt("hbase.quota.default.user.machine.read.num", 2);
        conf.set("hbase.quota.rate.limiter", "org.apache.hadoop.hbase.quotas.FixedIntervalRateLimiter");
        conf.set("hbase.quota.rate.limiter.refill.interval.ms", "300000");
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{MyCoprocessor.class.getName()});
        UTIL.startMiniCluster(3);
        byte[][] splitKeys = new byte[8][];
        for (int i = 111; i < 999; i += 111) {
            splitKeys[i / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i));
        }
        UTIL.createTable(TABLE_NAME, CF, (byte[][])splitKeys);
        CONN = UTIL.getConnection();
        TABLE = CONN.getTable(TABLE_NAME);
        TABLE.put(new Put(Bytes.toBytes((String)String.format("%d", 0))).addColumn(CF, CQ, Bytes.toBytes((long)0L)));
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGet() throws InterruptedException, ExecutionException, IOException {
        for (int i = 0; i < 5; ++i) {
            TABLE.get(new Get(Bytes.toBytes((String)"000")));
        }
        Assert.assertTrue((String)"Throttling did not happen as expected", (boolean)THROTTLING_OCCURRED.get());
    }

    static {
        THROTTLING_OCCURRED = new AtomicBoolean(false);
    }

    public static class MyCoprocessor
    implements RegionCoprocessor {
        RegionObserver observer = new MyRegionObserver();

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this.observer);
        }
    }

    public static class MyRegionObserver
    implements RegionObserver {
        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            if (!THROTTLING_OCCURRED.get()) {
                try {
                    ((RegionCoprocessorEnvironment)c.getEnvironment()).checkBatchQuota(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion(), OperationQuota.OperationType.GET);
                }
                catch (RpcThrottlingException e) {
                    THROTTLING_OCCURRED.set(true);
                    throw e;
                }
            }
        }
    }
}

