/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKLeaderManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ZKTests.class, MediumTests.class})
public class TestZKLeaderManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKLeaderManager.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestZKLeaderManager.class);
    private static final String LEADER_ZNODE = "/test/" + TestZKLeaderManager.class.getSimpleName();
    private static HBaseZKTestingUtility TEST_UTIL;
    private static MockLeader[] CANDIDATES;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseZKTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        MockAbortable abortable = new MockAbortable();
        int count = 5;
        CANDIDATES = new MockLeader[count];
        for (int i = 0; i < count; ++i) {
            ZKWatcher watcher = TestZKLeaderManager.newZK(conf, "server" + i, abortable);
            TestZKLeaderManager.CANDIDATES[i] = new MockLeader(watcher, i);
            CANDIDATES[i].start();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLeaderSelection() throws Exception {
        MockLeader currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"Leader should exist", (Object)currentLeader);
        LOG.debug("Current leader index is " + currentLeader.getIndex());
        byte[] znodeData = ZKUtil.getData((ZKWatcher)currentLeader.getWatcher(), (String)LEADER_ZNODE);
        Assert.assertNotNull((String)"Leader znode should contain leader index", (Object)znodeData);
        Assert.assertTrue((String)"Leader znode should not be empty", (znodeData.length > 0 ? 1 : 0) != 0);
        int storedIndex = Bytes.toInt((byte[])znodeData);
        LOG.debug("Stored leader index in ZK is " + storedIndex);
        Assert.assertEquals((String)"Leader znode should match leader index", (long)currentLeader.getIndex(), (long)storedIndex);
        currentLeader.abdicate();
        currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"New leader should exist after abdication", (Object)currentLeader);
        LOG.debug("New leader index is " + currentLeader.getIndex());
        znodeData = ZKUtil.getData((ZKWatcher)currentLeader.getWatcher(), (String)LEADER_ZNODE);
        Assert.assertNotNull((String)"Leader znode should contain leader index", (Object)znodeData);
        Assert.assertTrue((String)"Leader znode should not be empty", (znodeData.length > 0 ? 1 : 0) != 0);
        storedIndex = Bytes.toInt((byte[])znodeData);
        LOG.debug("Stored leader index in ZK is " + storedIndex);
        Assert.assertEquals((String)"Leader znode should match leader index", (long)currentLeader.getIndex(), (long)storedIndex);
        currentLeader.stop("Stopping for test");
        currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"New leader should exist after stop", (Object)currentLeader);
        LOG.debug("New leader index is " + currentLeader.getIndex());
        znodeData = ZKUtil.getData((ZKWatcher)currentLeader.getWatcher(), (String)LEADER_ZNODE);
        Assert.assertNotNull((String)"Leader znode should contain leader index", (Object)znodeData);
        Assert.assertTrue((String)"Leader znode should not be empty", (znodeData.length > 0 ? 1 : 0) != 0);
        storedIndex = Bytes.toInt((byte[])znodeData);
        LOG.debug("Stored leader index in ZK is " + storedIndex);
        Assert.assertEquals((String)"Leader znode should match leader index", (long)currentLeader.getIndex(), (long)storedIndex);
        currentLeader.stop("Stopping for test");
        currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"New leader should exist", (Object)currentLeader);
    }

    private MockLeader getCurrentLeader() {
        MockLeader currentLeader = null;
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < CANDIDATES.length; ++j) {
                if (!CANDIDATES[j].isMaster()) continue;
                if (currentLeader != null) {
                    Assert.fail((String)("Both candidate " + currentLeader.getIndex() + " and " + j + " claim to be leader!"));
                }
                currentLeader = CANDIDATES[j];
            }
            if (currentLeader != null) break;
            Threads.sleep((long)100L);
        }
        return currentLeader;
    }

    private static ZKWatcher newZK(Configuration conf, String name, Abortable abort) throws Exception {
        Configuration copy = HBaseConfiguration.create((Configuration)conf);
        return new ZKWatcher(copy, name, abort);
    }

    private static class MockLeader
    extends Thread
    implements Stoppable {
        private volatile boolean stopped;
        private ZKWatcher watcher;
        private ZKLeaderManager zkLeader;
        private AtomicBoolean master = new AtomicBoolean(false);
        private int index;

        MockLeader(ZKWatcher watcher, int index) {
            this.setDaemon(true);
            this.setName("TestZKLeaderManager-leader-" + index);
            this.index = index;
            this.watcher = watcher;
            this.zkLeader = new ZKLeaderManager(watcher, LEADER_ZNODE, Bytes.toBytes((int)index), (Stoppable)this);
        }

        public boolean isMaster() {
            return this.master.get();
        }

        public int getIndex() {
            return this.index;
        }

        public ZKWatcher getWatcher() {
            return this.watcher;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                this.zkLeader.start();
                this.zkLeader.waitToBecomeLeader();
                this.master.set(true);
                while (this.master.get() && !this.stopped) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        void abdicate() {
            this.zkLeader.stepDownAsLeader();
            this.master.set(false);
        }

        public void stop(String why) {
            this.stopped = true;
            this.abdicate();
            Threads.sleep((long)100L);
            this.watcher.close();
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }

    private static class MockAbortable
    implements Abortable {
        private boolean aborted;

        private MockAbortable() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
            LOG.error(HBaseMarkers.FATAL, "Aborting during test: " + why, e);
            Assert.fail((String)("Aborted during test: " + why));
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

