/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.field;

import java.util.EnumMap;
import java.util.List;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FieldScreenView
extends AbstractScreenView {
    private static final int SCREEN_DESCRIPTION_START_ROW = 0;
    private static final int FIELD_START_ROW = 5;
    private final FieldScreenPresenter fieldScreenPresenter;

    public FieldScreenView(Screen screen, Terminal terminal, Field sortField, List<Field> fields, EnumMap<Field, Boolean> fieldDisplayMap, FieldScreenPresenter.ResultListener resultListener, ScreenView nextScreenView) {
        super(screen, terminal);
        this.fieldScreenPresenter = new FieldScreenPresenter(this, sortField, fields, fieldDisplayMap, resultListener, nextScreenView);
    }

    @Override
    public void init() {
        this.fieldScreenPresenter.init();
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        switch (keyPress.getType()) {
            case Escape: {
                return this.fieldScreenPresenter.transitionToNextScreen();
            }
            case ArrowUp: {
                this.fieldScreenPresenter.arrowUp();
                return this;
            }
            case ArrowDown: {
                this.fieldScreenPresenter.arrowDown();
                return this;
            }
            case PageUp: 
            case Home: {
                this.fieldScreenPresenter.pageUp();
                return this;
            }
            case PageDown: 
            case End: {
                this.fieldScreenPresenter.pageDown();
                return this;
            }
            case ArrowRight: {
                this.fieldScreenPresenter.turnOnMoveMode();
                return this;
            }
            case ArrowLeft: 
            case Enter: {
                this.fieldScreenPresenter.turnOffMoveMode();
                return this;
            }
        }
        if (keyPress.getType() != KeyPress.Type.Character) {
            return this;
        }
        assert (keyPress.getCharacter() != null);
        switch (keyPress.getCharacter().charValue()) {
            case ' ': 
            case 'd': {
                this.fieldScreenPresenter.switchFieldDisplay();
                break;
            }
            case 's': {
                this.fieldScreenPresenter.setSortField();
                break;
            }
            case 'q': {
                return this.fieldScreenPresenter.transitionToNextScreen();
            }
        }
        return this;
    }

    public void showFieldScreen(String sortFieldHeader, List<Field> fields, EnumMap<Field, Boolean> fieldDisplayMap, int currentPosition, int headerMaxLength, int descriptionMaxLength, boolean moveMode) {
        this.showScreenDescription(sortFieldHeader);
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            this.showField(i, field, fieldDisplayMap.get((Object)field), i == currentPosition, headerMaxLength, descriptionMaxLength, moveMode);
        }
    }

    public void showScreenDescription(String sortFieldHeader) {
        TerminalPrinter printer = this.getTerminalPrinter(0);
        printer.startBold().print("Fields Management").stopBold().endOfLine();
        printer.print("Current Sort Field: ").startBold().print(sortFieldHeader).stopBold().endOfLine();
        printer.print("Navigate with up/down, Right selects for move then <Enter> or Left commits,").endOfLine();
        printer.print("'d' or <Space> toggles display, 's' sets sort. Use 'q' or <Esc> to end!").endOfLine();
    }

    public void showField(int pos, Field field, boolean display, boolean selected, int fieldHeaderMaxLength, int fieldDescriptionMaxLength, boolean moveMode) {
        String fieldHeader = String.format("%-" + fieldHeaderMaxLength + "s", field.getHeader());
        String fieldDescription = String.format("%-" + fieldDescriptionMaxLength + "s", field.getDescription());
        int row = 5 + pos;
        TerminalPrinter printer = this.getTerminalPrinter(row);
        if (selected) {
            String prefix;
            String string = prefix = display ? "* " : "  ";
            if (moveMode) {
                printer.print(prefix);
                if (display) {
                    printer.startBold();
                }
                printer.startHighlight().printFormat("%s = %s", fieldHeader, fieldDescription).stopHighlight();
                if (display) {
                    printer.stopBold();
                }
                printer.endOfLine();
            } else {
                printer.print(prefix);
                if (display) {
                    printer.startBold();
                }
                printer.startHighlight().print(fieldHeader).stopHighlight().printFormat(" = %s", fieldDescription);
                if (display) {
                    printer.stopBold();
                }
                printer.endOfLine();
            }
        } else if (display) {
            printer.print("* ").startBold().printFormat("%s = %s", fieldHeader, fieldDescription).stopBold().endOfLine();
        } else {
            printer.printFormat("  %s = %s", fieldHeader, fieldDescription).endOfLine();
        }
    }
}

