/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManagerUtil;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MergeTableRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.MergeTableRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTableRegionsProcedure.class);
    private ServerName regionLocation;
    private RegionInfo[] regionsToMerge;
    private RegionInfo mergedRegion;
    private boolean force;

    public MergeTableRegionsProcedure() {
    }

    public MergeTableRegionsProcedure(MasterProcedureEnv env, RegionInfo[] regionsToMerge, boolean force) throws IOException {
        super(env);
        MergeTableRegionsProcedure.checkRegionsToMerge(env, regionsToMerge, force);
        Arrays.sort(regionsToMerge);
        this.regionsToMerge = regionsToMerge;
        this.mergedRegion = MergeTableRegionsProcedure.createMergedRegionInfo(regionsToMerge);
        this.preflightChecks(env, true);
        this.force = force;
    }

    private static void checkRegionsToMerge(MasterProcedureEnv env, RegionInfo[] regions, boolean force) throws MergeRegionException {
        long count = Arrays.stream(regions).distinct().count();
        if ((long)regions.length != count) {
            throw new MergeRegionException("Duplicate regions specified; cannot merge a region to itself. Passed in " + regions.length + " but only " + count + " unique.");
        }
        if (count < 2L) {
            throw new MergeRegionException("Need two Regions at least to run a Merge");
        }
        RegionInfo previous = null;
        for (RegionInfo ri : regions) {
            if (previous != null) {
                if (!previous.getTable().equals(ri.getTable())) {
                    String msg = "Can't merge regions from different tables: " + previous + ", " + ri;
                    LOG.warn(msg);
                    throw new MergeRegionException(msg);
                }
                if (!(force || ri.isAdjacent(previous) || ri.isOverlap(previous))) {
                    String msg = "Unable to merge non-adjacent or non-overlapping regions '" + previous.getShortNameToLog() + "', '" + ri.getShortNameToLog() + "' when force=false";
                    LOG.warn(msg);
                    throw new MergeRegionException(msg);
                }
            }
            if (ri.getReplicaId() != 0) {
                throw new MergeRegionException("Can't merge non-default replicas; " + ri);
            }
            try {
                MergeTableRegionsProcedure.checkOnline(env, ri);
            }
            catch (DoNotRetryRegionException dnrre) {
                throw new MergeRegionException(dnrre);
            }
            previous = ri;
        }
    }

    private static RegionInfo createMergedRegionInfo(RegionInfo[] regionsToMerge) {
        byte[] lowestStartKey = null;
        byte[] highestEndKey = null;
        long highestRegionId = -1L;
        for (RegionInfo ri : regionsToMerge) {
            if (lowestStartKey == null) {
                lowestStartKey = ri.getStartKey();
            } else if (Bytes.compareTo(ri.getStartKey(), lowestStartKey) < 0) {
                lowestStartKey = ri.getStartKey();
            }
            if (highestEndKey == null) {
                highestEndKey = ri.getEndKey();
            } else if (ri.isLast() || Bytes.compareTo(ri.getEndKey(), highestEndKey) > 0) {
                highestEndKey = ri.getEndKey();
            }
            highestRegionId = ri.getRegionId() > highestRegionId ? ri.getRegionId() : highestRegionId;
        }
        return RegionInfoBuilder.newBuilder(regionsToMerge[0].getTable()).setStartKey(lowestStartKey).setEndKey(highestEndKey).setSplit(false).setRegionId(highestRegionId + 1L).build();
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MergeTableRegionsState state) {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MERGE_TABLE_REGIONS_PREPARE: {
                    if (!this.prepareMergeRegion(env)) {
                        assert (this.isFailed()) : "Merge region should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION: {
                    this.preMergeRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CLOSE_REGIONS);
                    break;
                }
                case MERGE_TABLE_REGIONS_CLOSE_REGIONS: {
                    this.addChildProcedure(this.createUnassignProcedures(env));
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CHECK_CLOSED_REGIONS);
                    break;
                }
                case MERGE_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    this.checkClosedRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CREATE_MERGED_REGION);
                    break;
                }
                case MERGE_TABLE_REGIONS_CREATE_MERGED_REGION: {
                    this.removeNonDefaultReplicas(env);
                    this.createMergedRegion(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_WRITE_MAX_SEQUENCE_ID_FILE);
                    break;
                }
                case MERGE_TABLE_REGIONS_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.writeMaxSequenceIdFile(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION: {
                    this.preMergeRegionsCommit(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_UPDATE_META);
                    break;
                }
                case MERGE_TABLE_REGIONS_UPDATE_META: {
                    this.updateMetaForMergedRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: {
                    this.postMergeRegionsCommit(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_OPEN_MERGED_REGION);
                    break;
                }
                case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: {
                    this.addChildProcedure(this.createAssignProcedures(env));
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_POST_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_POST_OPERATION: {
                    this.postCompletedMergeRegions(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            String msg = "Error trying to merge " + RegionInfo.getShortNameToLog(this.regionsToMerge) + " in " + this.getTableName() + " (in state=" + state + ")";
            if (!this.isRollbackSupported(state)) {
                LOG.warn(msg, (Throwable)e);
            }
            LOG.error(msg, (Throwable)e);
            this.setFailure("master-merge-regions", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.MergeTableRegionsState state) throws IOException {
        LOG.trace("{} rollback state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MERGE_TABLE_REGIONS_UPDATE_META: 
                case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: 
                case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: 
                case MERGE_TABLE_REGIONS_POST_OPERATION: {
                    String msg = this + " We are in the " + state + " state. It is complicated to rollback the merge operation that region server is working on. Rollback is not supported and we should let the merge operation to complete";
                    LOG.warn(msg);
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION: {
                    break;
                }
                case MERGE_TABLE_REGIONS_CREATE_MERGED_REGION: 
                case MERGE_TABLE_REGIONS_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.cleanupMergedRegion(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    break;
                }
                case MERGE_TABLE_REGIONS_CLOSE_REGIONS: {
                    this.rollbackCloseRegionsForMerge(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION: {
                    this.postRollBackMergeRegions(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_PREPARE: {
                    this.rollbackPrepareMerge(env);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed rollback attempt step " + state + " for merging the regions " + RegionInfo.getShortNameToLog(this.regionsToMerge) + " in table " + this.getTableName(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.MergeTableRegionsState state) {
        switch (state) {
            case MERGE_TABLE_REGIONS_UPDATE_META: 
            case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: 
            case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: 
            case MERGE_TABLE_REGIONS_POST_OPERATION: {
                return false;
            }
        }
        return true;
    }

    private void removeNonDefaultReplicas(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.removeNonDefaultReplicas(env, Stream.of(this.regionsToMerge), this.getRegionReplication(env));
    }

    private void checkClosedRegions(MasterProcedureEnv env) throws IOException {
        for (RegionInfo region : this.regionsToMerge) {
            AssignmentManagerUtil.checkClosedRegion(env, region);
        }
    }

    @Override
    protected MasterProcedureProtos.MergeTableRegionsState getState(int stateId) {
        return MasterProcedureProtos.MergeTableRegionsState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.MergeTableRegionsState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.MergeTableRegionsState getInitialState() {
        return MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.MergeTableRegionsStateData.Builder mergeTableRegionsMsg = MasterProcedureProtos.MergeTableRegionsStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setMergedRegionInfo(ProtobufUtil.toRegionInfo(this.mergedRegion)).setForcible(this.force);
        for (RegionInfo ri : this.regionsToMerge) {
            mergeTableRegionsMsg.addRegionInfo(ProtobufUtil.toRegionInfo(ri));
        }
        serializer.serialize(mergeTableRegionsMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.MergeTableRegionsStateData mergeTableRegionsMsg = serializer.deserialize(MasterProcedureProtos.MergeTableRegionsStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(mergeTableRegionsMsg.getUserInfo()));
        assert (mergeTableRegionsMsg.getRegionInfoCount() == 2);
        this.regionsToMerge = new RegionInfo[mergeTableRegionsMsg.getRegionInfoCount()];
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            this.regionsToMerge[i] = ProtobufUtil.toRegionInfo(mergeTableRegionsMsg.getRegionInfo(i));
        }
        this.mergedRegion = ProtobufUtil.toRegionInfo(mergeTableRegionsMsg.getMergedRegionInfo());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", regions=");
        sb.append(RegionInfo.getShortNameToLog(this.regionsToMerge));
        sb.append(", force=");
        sb.append(this.force);
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        RegionInfo[] lockRegions = Arrays.copyOf(this.regionsToMerge, this.regionsToMerge.length + 1);
        lockRegions[lockRegions.length - 1] = this.mergedRegion;
        if (env.getProcedureScheduler().waitRegions(this, this.getTableName(), lockRegions)) {
            try {
                LOG.debug((Object)((Object)Procedure.LockState.LOCK_EVENT_WAIT) + " " + env.getProcedureScheduler().dumpLocks());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        RegionInfo[] lockRegions = Arrays.copyOf(this.regionsToMerge, this.regionsToMerge.length + 1);
        lockRegions[lockRegions.length - 1] = this.mergedRegion;
        env.getProcedureScheduler().wakeRegions(this, this.getTableName(), lockRegions);
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    public TableName getTableName() {
        return this.mergedRegion.getTable();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_MERGE;
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getMergeProcMetrics();
    }

    private boolean prepareMergeRegion(MasterProcedureEnv env) throws IOException {
        TableName tn = this.regionsToMerge[0].getTable();
        String regionNamesToLog = RegionInfo.getShortNameToLog(this.regionsToMerge);
        if (env.getMasterServices().getSnapshotManager().isTableTakingAnySnapshot(tn)) {
            throw new MergeRegionException("Skip merging regions " + regionNamesToLog + ", because we are snapshotting " + tn);
        }
        if (this.isTableModificationInProgress(env)) {
            this.setFailure(this.getClass().getSimpleName(), new IOException("Skip merging regions " + regionNamesToLog + ", because there is an active procedure that is modifying the table " + tn));
            return false;
        }
        if (!env.getMasterServices().isSplitOrMergeEnabled(MasterSwitchType.MERGE)) {
            LOG.warn("Merge switch is off! skip merge of " + regionNamesToLog);
            this.setFailure(this.getClass().getSimpleName(), new IOException("Merge of " + regionNamesToLog + " failed because merge switch is off"));
            return false;
        }
        if (!env.getMasterServices().getTableDescriptors().get(this.getTableName()).isMergeEnabled()) {
            LOG.warn("Merge is disabled for the table! Skipping merge of {}", (Object)regionNamesToLog);
            this.setFailure(this.getClass().getSimpleName(), new IOException("Merge of " + regionNamesToLog + " failed as region merge is disabled for the table"));
            return false;
        }
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        for (RegionInfo ri : this.regionsToMerge) {
            if (MetaTableAccessor.hasMergeRegions(env.getMasterServices().getConnection(), ri)) {
                String msg = "Skip merging " + regionNamesToLog + ", because a parent, " + RegionInfo.getShortNameToLog(ri) + ", has a merge qualifier (if a 'merge column' in parent, it was recently merged but still has outstanding references to its parents that must be cleared before it can participate in merge -- major compact it to hurry clearing of its references)";
                LOG.warn(msg);
                throw new MergeRegionException(msg);
            }
            RegionState state = regionStates.getRegionState(ri.getEncodedName());
            if (state == null) {
                throw new UnknownRegionException(RegionInfo.getShortNameToLog(ri) + " UNKNOWN (Has it been garbage collected?)");
            }
            if (!state.isOpened()) {
                throw new MergeRegionException("Unable to merge regions that are NOT online: " + ri);
            }
            try {
                if (this.isMergeable(env, state)) continue;
                this.setFailure(this.getClass().getSimpleName(), new MergeRegionException("Skip merging " + regionNamesToLog + ", because a parent, " + RegionInfo.getShortNameToLog(ri) + ", is not mergeable"));
                return false;
            }
            catch (IOException e) {
                IOException ioe = new IOException(RegionInfo.getShortNameToLog(ri) + " NOT mergeable", e);
                this.setFailure(this.getClass().getSimpleName(), ioe);
                return false;
            }
        }
        this.setRegionStateToMerging(env);
        return true;
    }

    private boolean isMergeable(MasterProcedureEnv env, RegionState rs) throws IOException {
        AdminProtos.GetRegionInfoResponse response = AssignmentManagerUtil.getRegionInfoResponse(env, rs.getServerName(), rs.getRegion());
        return response.hasMergeable() && response.getMergeable();
    }

    private void rollbackPrepareMerge(MasterProcedureEnv env) throws IOException {
        for (RegionInfo rinfo : this.regionsToMerge) {
            RegionStateNode regionStateNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(rinfo);
            if (regionStateNode.getState() != RegionState.State.MERGING) continue;
            regionStateNode.setState(RegionState.State.OPEN, new RegionState.State[0]);
        }
    }

    private void preMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preMergeRegionsAction(this.regionsToMerge, this.getUser());
        }
        try {
            MasterQuotaManager masterQuotaManager = env.getMasterServices().getMasterQuotaManager();
            if (masterQuotaManager != null) {
                masterQuotaManager.onRegionMerged(this.mergedRegion);
            }
        }
        catch (QuotaExceededException e) {
            env.getMasterServices().getRegionNormalizerManager().planSkipped(NormalizationPlan.PlanType.MERGE);
            throw e;
        }
    }

    private void postRollBackMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRollBackMergeRegionsAction(this.regionsToMerge, this.getUser());
        }
    }

    private void setRegionStateToMerging(MasterProcedureEnv env) {
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        for (RegionInfo ri : this.regionsToMerge) {
            regionStates.getRegionStateNode(ri).setState(RegionState.State.MERGING, new RegionState.State[0]);
        }
    }

    private void createMergedRegion(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tableDir = CommonFSUtils.getTableDir(mfs.getRootDir(), this.regionsToMerge[0].getTable());
        FileSystem fs = mfs.getFileSystem();
        ArrayList<Path> mergedFiles = new ArrayList<Path>();
        HRegionFileSystem mergeRegionFs = HRegionFileSystem.createRegionOnFileSystem(env.getMasterConfiguration(), fs, tableDir, this.mergedRegion);
        for (RegionInfo ri : this.regionsToMerge) {
            HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tableDir, ri, false);
            mergedFiles.addAll(this.mergeStoreFiles(env, regionFs, mergeRegionFs, this.mergedRegion));
        }
        assert (mergeRegionFs != null);
        mergeRegionFs.commitMergedRegion(mergedFiles, env);
        env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.mergedRegion).setState(RegionState.State.MERGING_NEW, new RegionState.State[0]);
    }

    private List<Path> mergeStoreFiles(MasterProcedureEnv env, HRegionFileSystem regionFs, HRegionFileSystem mergeRegionFs, RegionInfo mergedRegion) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(mergedRegion.getTable());
        ArrayList<Path> mergedFiles = new ArrayList<Path>();
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            String family = hcd.getNameAsString();
            StoreFileTracker tracker = StoreFileTrackerFactory.create(env.getMasterConfiguration(), htd, hcd, regionFs);
            List<StoreFileInfo> storeFiles = tracker.load();
            if (storeFiles == null || storeFiles.size() <= 0) continue;
            Configuration storeConfiguration = StoreUtils.createStoreConfiguration(env.getMasterConfiguration(), htd, hcd);
            for (StoreFileInfo storeFileInfo : storeFiles) {
                storeFileInfo.setConf(storeConfiguration);
                Path refFile = mergeRegionFs.mergeStoreFile(regionFs.getRegionInfo(), family, new HStoreFile(storeFileInfo, hcd.getBloomFilterType(), CacheConfig.DISABLED));
                mergedFiles.add(refFile);
            }
        }
        return mergedFiles;
    }

    private void cleanupMergedRegion(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        TableName tn = this.regionsToMerge[0].getTable();
        Path tabledir = CommonFSUtils.getTableDir(mfs.getRootDir(), tn);
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.regionsToMerge[0], false);
        regionFs.cleanupMergedRegion(this.mergedRegion);
    }

    private void rollbackCloseRegionsForMerge(MasterProcedureEnv env) throws IOException {
        ArrayList<RegionInfo> toAssign = new ArrayList<RegionInfo>();
        for (RegionInfo rinfo : this.regionsToMerge) {
            RegionStateNode regionStateNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(rinfo);
            if (regionStateNode.getState() == RegionState.State.MERGING) continue;
            toAssign.add(rinfo);
        }
        AssignmentManagerUtil.reopenRegionsForRollback(env, toAssign, this.getRegionReplication(env), this.getServerName(env));
    }

    private TransitRegionStateProcedure[] createUnassignProcedures(MasterProcedureEnv env) throws IOException {
        return AssignmentManagerUtil.createUnassignProceduresForSplitOrMerge(env, Stream.of(this.regionsToMerge), this.getRegionReplication(env));
    }

    private TransitRegionStateProcedure[] createAssignProcedures(MasterProcedureEnv env) throws IOException {
        return AssignmentManagerUtil.createAssignProceduresForOpeningNewRegions(env, Collections.singletonList(this.mergedRegion), this.getRegionReplication(env), this.getServerName(env));
    }

    private int getRegionReplication(MasterProcedureEnv env) throws IOException {
        return env.getMasterServices().getTableDescriptors().get(this.getTableName()).getRegionReplication();
    }

    private void preMergeRegionsCommit(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
            cpHost.preMergeRegionsCommit(this.regionsToMerge, metaEntries, this.getUser());
            try {
                for (Mutation p : metaEntries) {
                    RegionInfo.parseRegionName(p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error("Row key of mutation from coprocessor is not parsable as region name. Mutations from coprocessor should only be for hbase:meta table.", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateMetaForMergedRegions(MasterProcedureEnv env) throws IOException {
        env.getAssignmentManager().markRegionAsMerged(this.mergedRegion, this.getServerName(env), this.regionsToMerge);
    }

    private void postMergeRegionsCommit(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postMergeRegionsCommit(this.regionsToMerge, this.mergedRegion, this.getUser());
        }
    }

    private void postCompletedMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postCompletedMergeRegionsAction(this.regionsToMerge, this.mergedRegion, this.getUser());
        }
    }

    private ServerName getServerName(MasterProcedureEnv env) {
        if (this.regionLocation == null) {
            this.regionLocation = env.getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.regionsToMerge[0]);
        }
        return this.regionLocation;
    }

    private void writeMaxSequenceIdFile(MasterProcedureEnv env) throws IOException {
        MasterFileSystem fs = env.getMasterFileSystem();
        long maxSequenceId = -1L;
        for (RegionInfo region : this.regionsToMerge) {
            maxSequenceId = Math.max(maxSequenceId, WALSplitUtil.getMaxRegionSequenceId(env.getMasterConfiguration(), region, fs::getFileSystem, fs::getWALFileSystem));
        }
        if (maxSequenceId > 0L) {
            WALSplitUtil.writeRegionSequenceIdFile(fs.getWALFileSystem(), this.getWALRegionDir(env, this.mergedRegion), maxSequenceId);
        }
    }

    RegionInfo getMergedRegion() {
        return this.mergedRegion;
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return this.isRollbackSupported((MasterProcedureProtos.MergeTableRegionsState)this.getCurrentState()) && super.abort(env);
    }
}

