/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.util.Arrays;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.IllegalNameIdentifierException;
import org.apache.gravitino.shaded.com.google.common.base.Splitter;
import org.apache.gravitino.shaded.com.google.common.collect.Iterables;
import org.apache.gravitino.shaded.com.google.errorprone.annotations.FormatMethod;
import org.apache.gravitino.shaded.com.google.errorprone.annotations.FormatString;

public class NameIdentifier {
    private static final Splitter DOT = Splitter.on('.');
    private final Namespace namespace;
    private final String name;

    public static NameIdentifier of(String ... names) {
        NameIdentifier.check(names != null, "Cannot create a NameIdentifier with null names", new Object[0]);
        NameIdentifier.check(names.length > 0, "Cannot create a NameIdentifier with no names", new Object[0]);
        return new NameIdentifier(Namespace.of(Arrays.copyOf(names, names.length - 1)), names[names.length - 1]);
    }

    public static NameIdentifier of(Namespace namespace, String name) {
        return new NameIdentifier(namespace, name);
    }

    public static NameIdentifier parse(String identifier) {
        NameIdentifier.check(identifier != null && !identifier.isEmpty(), "Cannot parse a null or empty identifier", new Object[0]);
        Iterable<String> parts = DOT.split(identifier);
        return NameIdentifier.of(Iterables.toArray(parts, String.class));
    }

    private NameIdentifier(Namespace namespace, String name) {
        NameIdentifier.check(namespace != null, "Cannot create a NameIdentifier with null namespace", new Object[0]);
        NameIdentifier.check(name != null && !name.isEmpty(), "Cannot create a NameIdentifier with null or empty name", new Object[0]);
        this.namespace = namespace;
        this.name = name;
    }

    public boolean hasNamespace() {
        return !this.namespace.isEmpty();
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NameIdentifier)) {
            return false;
        }
        NameIdentifier otherNameIdentifier = (NameIdentifier)other;
        return this.namespace.equals(otherNameIdentifier.namespace) && this.name.equals(otherNameIdentifier.name);
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.namespace.hashCode(), this.name.hashCode()});
    }

    public String toString() {
        if (this.hasNamespace()) {
            return this.namespace.toString() + "." + this.name;
        }
        return this.name;
    }

    @FormatMethod
    public static void check(boolean condition, @FormatString String message, Object ... args) {
        if (!condition) {
            throw new IllegalNameIdentifierException(message, args);
        }
    }
}

