/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.authorization.UserDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class UserResponse
extends BaseResponse {
    @JsonProperty(value="user")
    private final UserDTO user;

    public UserResponse(UserDTO user) {
        super(0);
        this.user = user;
    }

    public UserResponse() {
        this.user = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.user != null ? 1 : 0) != 0, (Object)"user must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.user.name()), (Object)"user 'name' must not be null and empty");
        Preconditions.checkArgument((this.user.auditInfo() != null ? 1 : 0) != 0, (Object)"user 'auditInfo' must not be null");
    }

    public UserDTO getUser() {
        return this.user;
    }

    @Override
    public String toString() {
        return "UserResponse(user=" + this.getUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserResponse)) {
            return false;
        }
        UserResponse other = (UserResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserDTO this$user = this.getUser();
        UserDTO other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserDTO $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }
}

