/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.PropertyEntry;

@Evolving
public interface PropertiesMetadata {
    public Map<String, PropertyEntry<?>> propertyEntries();

    default public boolean isReservedProperty(String propertyName) {
        if (this.getNonPrefixEntry(propertyName).map(PropertyEntry::isReserved).orElse(false).booleanValue()) {
            return true;
        }
        return this.getPropertyPrefixEntry(propertyName).map(PropertyEntry::isReserved).orElse(false);
    }

    default public boolean isRequiredProperty(String propertyName) {
        if (this.getNonPrefixEntry(propertyName).map(PropertyEntry::isRequired).orElse(false).booleanValue()) {
            return true;
        }
        return this.getPropertyPrefixEntry(propertyName).map(PropertyEntry::isRequired).orElse(false);
    }

    default public boolean isImmutableProperty(String propertyName) {
        if (this.getNonPrefixEntry(propertyName).map(PropertyEntry::isImmutable).orElse(false).booleanValue()) {
            return true;
        }
        return this.getPropertyPrefixEntry(propertyName).map(PropertyEntry::isImmutable).orElse(false);
    }

    default public boolean isHiddenProperty(String propertyName) {
        if (this.getNonPrefixEntry(propertyName).map(PropertyEntry::isHidden).orElse(false).booleanValue()) {
            return true;
        }
        return this.getPropertyPrefixEntry(propertyName).map(PropertyEntry::isHidden).orElse(false);
    }

    default public boolean containsProperty(String propertyName) {
        return this.getNonPrefixEntry(propertyName).isPresent() || this.getPropertyPrefixEntry(propertyName).isPresent();
    }

    default public Object getOrDefault(Map<String, String> properties, String propertyName) {
        PropertyEntry<?> propertyEntry = this.getPropertyEntry(propertyName);
        if (properties != null && properties.containsKey(propertyName)) {
            return propertyEntry.decode(properties.get(propertyName));
        }
        return propertyEntry.getDefaultValue();
    }

    default public Object getDefaultValue(String propertyName) {
        PropertyEntry<?> propertyEntry = this.getPropertyEntry(propertyName);
        return propertyEntry.getDefaultValue();
    }

    default public PropertyEntry<?> getPropertyEntry(String propertyName) throws IllegalArgumentException {
        if (!this.containsProperty(propertyName)) {
            throw new IllegalArgumentException("Property is not defined: " + propertyName);
        }
        return this.getNonPrefixEntry(propertyName).isPresent() ? this.getNonPrefixEntry(propertyName).get() : this.getPropertyPrefixEntry(propertyName).get();
    }

    default public Optional<PropertyEntry<?>> getPropertyPrefixEntry(String propertyName) {
        return this.propertyEntries().entrySet().stream().filter(e -> ((PropertyEntry)e.getValue()).isPrefix() && propertyName.startsWith((String)e.getKey())).max(Map.Entry.comparingByKey(Comparator.comparingInt(String::length))).map(Map.Entry::getValue);
    }

    default public Optional<PropertyEntry<?>> getNonPrefixEntry(String propertyName) {
        if (this.propertyEntries().containsKey(propertyName) && !this.propertyEntries().get(propertyName).isPrefix()) {
            return Optional.of(this.propertyEntries().get(propertyName));
        }
        return Optional.empty();
    }
}

