/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.MetadataObject;

public interface AuthorizationMetadataObject {
    public static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    public static final Joiner DOT_JOINER = Joiner.on((char)'.');

    @Nullable
    public String parent();

    public String name();

    public List<String> names();

    default public String fullName() {
        if (this.parent() == null) {
            return this.name();
        }
        return this.parent() + "." + this.name();
    }

    public static String getParentFullName(List<String> names) {
        if (names.size() <= 1) {
            return null;
        }
        return DOT_JOINER.join(names.subList(0, names.size() - 1));
    }

    public static String getLastName(List<String> names) {
        Preconditions.checkArgument((names.size() > 0 ? 1 : 0) != 0, (Object)"Cannot get the last name of an empty list");
        return names.get(names.size() - 1);
    }

    public Type type();

    default public MetadataObject.Type metadataObjectType() {
        return this.type().metadataObjectType();
    }

    public void validateAuthorizationMetadataObject() throws IllegalArgumentException;

    public static interface Type {
        public MetadataObject.Type metadataObjectType();
    }
}

