/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.snapshot.SnapshotOptionsImpl;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class ExportDataFunction
extends CliFunction<String[]> {
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.ExportDataFunction";

    public String getId() {
        return ID;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<String[]> context) throws Exception {
        CliFunctionResult result;
        String[] args = (String[])context.getArguments();
        if (args.length < 3) {
            throw new IllegalStateException("Arguments length does not match required length. Export command may have been sent from incompatible older version");
        }
        String regionName = args[0];
        String fileName = args[1];
        boolean parallel = Boolean.parseBoolean(args[2]);
        InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
        Region region = cache.getRegion(regionName);
        String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
        if (region != null) {
            RegionSnapshotService snapshotService = region.getSnapshotService();
            File exportFile = new File(fileName);
            if (parallel) {
                SnapshotOptions options = new SnapshotOptionsImpl().setParallelMode(true);
                snapshotService.save(exportFile, SnapshotOptions.SnapshotFormat.GEODE, options);
            } else {
                snapshotService.save(exportFile, SnapshotOptions.SnapshotFormat.GEODE);
            }
            String successMessage = CliStrings.format((String)"Data successfully exported from region : {0} to file : {1} on host : {2}", (Object[])new Object[]{regionName, exportFile.getCanonicalPath(), hostName});
            result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, successMessage);
        } else {
            result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"Region : {0} not found", (Object)regionName));
        }
        return result;
    }
}

