/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.StandardErrorPrinter;
import org.apache.geode.logging.internal.spi.LogWriterLevel;
import org.apache.logging.log4j.Logger;

public class LoggingThreadGroup
extends ThreadGroup {
    @Immutable
    private static final StandardErrorPrinter stderr = new StandardErrorPrinter(LogWriterLevel.ALL.intLevel());
    @MakeNotStatic
    private static final Collection<LoggingThreadGroup> loggingThreadGroups = new ArrayList<LoggingThreadGroup>();
    protected volatile InternalLogWriter logWriter;
    protected volatile Logger logger;
    private long uncaughtExceptionsCount;
    private final Object dispatchLock = new Object();

    public static LoggingThreadGroup createThreadGroup(String name) {
        return LoggingThreadGroup.createThreadGroup(name, (Logger)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingThreadGroup createThreadGroup(String name, InternalLogWriter logWriter) {
        ThreadGroup group = null;
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            Iterator<LoggingThreadGroup> iter = loggingThreadGroups.iterator();
            while (iter.hasNext()) {
                LoggingThreadGroup group2 = iter.next();
                if (group2.isDestroyed()) {
                    iter.remove();
                    continue;
                }
                if (!name.equals(group2.getName())) continue;
                if (logWriter != group2.logWriter) {
                    group2.logWriter = logWriter;
                }
                group = group2;
                break;
            }
            if (group == null) {
                group = new LoggingThreadGroup(name, logWriter);
                group.setDaemon(false);
                loggingThreadGroups.add((LoggingThreadGroup)group);
            }
        }
        Assert.assertTrue(!group.isDestroyed());
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingThreadGroup createThreadGroup(String name, Logger logger) {
        ThreadGroup group = null;
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            Iterator<LoggingThreadGroup> iter = loggingThreadGroups.iterator();
            while (iter.hasNext()) {
                LoggingThreadGroup group2 = iter.next();
                if (group2.isDestroyed()) {
                    iter.remove();
                    continue;
                }
                if (!name.equals(group2.getName())) continue;
                if (logger != group2.logger) {
                    group2.logger = logger;
                }
                group = group2;
                break;
            }
            if (group == null) {
                group = new LoggingThreadGroup(name, logger);
                group.setDaemon(false);
                loggingThreadGroups.add((LoggingThreadGroup)group);
            }
        }
        Assert.assertTrue(!group.isDestroyed());
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpThreadGroups() {
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            for (LoggingThreadGroup loggingThreadGroup : loggingThreadGroups) {
                if (loggingThreadGroup.getName().equals("Distributed system shutdown hook") || loggingThreadGroup.getName().equals("GemFireConnectionFactory Shutdown Hook")) continue;
                loggingThreadGroup.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadGroup getThreadGroup(String threadGroupName) {
        Collection<LoggingThreadGroup> collection = loggingThreadGroups;
        synchronized (collection) {
            for (LoggingThreadGroup object : loggingThreadGroups) {
                LoggingThreadGroup threadGroup = object;
                if (!threadGroup.getName().equals(threadGroupName)) continue;
                return threadGroup;
            }
            return null;
        }
    }

    LoggingThreadGroup(String name, InternalLogWriter logWriter) {
        super(name);
        this.logWriter = logWriter;
    }

    LoggingThreadGroup(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        Object object = this.dispatchLock;
        synchronized (object) {
            if (ex instanceof VirtualMachineError) {
                SystemFailure.setFailure((VirtualMachineError)ex);
            }
            String threadName = t.getName();
            if (ex instanceof NoClassDefFoundError && threadName.equals("Distributed system shutdown hook")) {
                String msg = "Uncaught exception in thread %s this message can be disregarded if it occurred during an Application Server shutdown. The Exception message was: %s";
                Object[] msgArgs = new Object[]{t, ex.getLocalizedMessage()};
                stderr.info(String.format("Uncaught exception in thread %s this message can be disregarded if it occurred during an Application Server shutdown. The Exception message was: %s", msgArgs));
                if (this.logger != null) {
                    this.logger.info(String.format("Uncaught exception in thread %s this message can be disregarded if it occurred during an Application Server shutdown. The Exception message was: %s", msgArgs));
                }
                if (this.logWriter != null) {
                    this.logWriter.info(String.format("Uncaught exception in thread %s this message can be disregarded if it occurred during an Application Server shutdown. The Exception message was: %s", msgArgs));
                }
            } else {
                stderr.severe(String.format("Uncaught exception in thread %s", t), ex);
                if (this.logger != null) {
                    this.logger.fatal(String.format("Uncaught exception in thread %s", t), ex);
                }
                if (this.logWriter != null) {
                    this.logWriter.severe(String.format("Uncaught exception in thread %s", t), ex);
                }
            }
            ++this.uncaughtExceptionsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUncaughtExceptionsCount() {
        Object object = this.dispatchLock;
        synchronized (object) {
            this.uncaughtExceptionsCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUncaughtExceptionsCount() {
        Object object = this.dispatchLock;
        synchronized (object) {
            return this.uncaughtExceptionsCount;
        }
    }

    public synchronized void cleanup() {
        this.logger = null;
        this.logWriter = null;
    }
}

