/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ServerLocator;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CacheServerAdvisor;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.ControllerAdvisor;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public abstract class GridAdvisor
extends DistributionAdvisor {
    private final Object cacheLock = new Object();
    private volatile List cachedBridgeServerProfiles;
    private volatile List cachedControllerProfiles;
    private volatile Set cachedBridgeServerAdvise;
    private volatile Set cachedControllerAdvise;
    @Immutable
    private static final Predicate<DistributionAdvisor.Profile> CONTROLLER_FILTER = profile -> profile instanceof ControllerAdvisor.ControllerProfile;
    @Immutable
    private static final Predicate<DistributionAdvisor.Profile> BRIDGE_SERVER_FILTER = profile -> profile instanceof CacheServerAdvisor.CacheServerProfile;

    protected GridAdvisor(DistributionAdvisee server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set adviseControllers() {
        Set<InternalDistributedMember> result = this.cachedControllerAdvise;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.cachedControllerAdvise;
                if (result == null) {
                    this.cachedControllerAdvise = result = Collections.unmodifiableSet(this.adviseFilter(CONTROLLER_FILTER));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set adviseBridgeServers() {
        Set<InternalDistributedMember> result = this.cachedBridgeServerAdvise;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.cachedBridgeServerAdvise;
                if (result == null) {
                    this.cachedBridgeServerAdvise = result = Collections.unmodifiableSet(this.adviseFilter(BRIDGE_SERVER_FILTER));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List fetchBridgeServers() {
        List<DistributionAdvisor.Profile> result = null;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (result == null) {
                    this.cachedBridgeServerProfiles = result = this.fetchProfiles(BRIDGE_SERVER_FILTER);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List fetchControllers() {
        List<DistributionAdvisor.Profile> result = this.cachedControllerProfiles;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.cachedControllerProfiles;
                if (result == null) {
                    this.cachedControllerProfiles = result = this.fetchProfiles(CONTROLLER_FILTER);
                }
            }
        }
        return result;
    }

    public int getBridgeServerCount() {
        List<DistributionAdvisor.Profile> l = this.cachedBridgeServerProfiles;
        if (l == null) {
            l = this.fetchProfiles(BRIDGE_SERVER_FILTER);
        }
        return l.size();
    }

    public int getControllerCount() {
        List<DistributionAdvisor.Profile> l = this.cachedControllerProfiles;
        if (l == null) {
            l = this.fetchProfiles(CONTROLLER_FILTER);
        }
        return l.size();
    }

    @Override
    public boolean useAdminMembersForDefault() {
        return true;
    }

    @Override
    protected boolean isCurrentMember(DistributionAdvisor.Profile p) {
        return true;
    }

    @Override
    protected void profileCreated(DistributionAdvisor.Profile profile) {
        this.profilesChanged();
    }

    @Override
    protected void profileUpdated(DistributionAdvisor.Profile profile) {
        this.profilesChanged();
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        this.profilesChanged();
    }

    protected void profilesChanged() {
        if (this.pollIsInitialized()) {
            this.cachedBridgeServerProfiles = null;
            this.cachedControllerProfiles = null;
            this.cachedBridgeServerAdvise = null;
            this.cachedControllerAdvise = null;
        }
    }

    public void handshake() {
        if (this.initializationGate()) {
            ArrayList<DistributionAdvisor.Profile> otherProfiles = new ArrayList<DistributionAdvisor.Profile>();
            GridProfile profile = (GridProfile)this.createProfile();
            profile.tellLocalBridgeServers(this.getDistributionManager().getCache(), false, true, otherProfiles);
            profile.tellLocalControllers(false, true, otherProfiles);
            for (DistributionAdvisor.Profile otherProfile : otherProfiles) {
                if (otherProfile.equals(profile)) continue;
                this.putProfile(otherProfile);
            }
        }
        this.profilesChanged();
    }

    @Override
    public void close() {
        try {
            new UpdateAttributesProcessor(this.getAdvisee(), true).distribute();
            GridProfile profile = (GridProfile)this.createProfile();
            profile.tellLocalBridgeServers(this.getDistributionManager().getCache(), true, false, null);
            profile.tellLocalControllers(true, false, null);
            super.close();
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
        this.profilesChanged();
    }

    public Set adviseProfileRemove() {
        Set<InternalDistributedMember> results = super.adviseProfileRemove();
        results.remove(this.getDistributionManager().getId());
        return results;
    }

    public static class GridProfileId
    implements DistributionAdvisor.ProfileId {
        private final GridProfile gp;

        public GridProfileId(GridProfile gp) {
            this.gp = gp;
        }

        public InternalDistributedMember getMemberId() {
            return this.gp.getDistributedMember();
        }

        public String getHost() {
            return this.gp.getHost();
        }

        public int getPort() {
            return this.gp.getPort();
        }

        public String toString() {
            return "GridProfile[host=" + this.gp.getHost() + ",port=" + this.gp.getPort() + ']';
        }

        public int hashCode() {
            String thisHost = this.gp.getHost();
            int thisPort = this.gp.getPort();
            String thisMemberId = this.getMemberId().getUniqueId();
            int thisMemberIdHashCode = thisMemberId != null ? thisMemberId.hashCode() : 0;
            return thisHost != null ? (thisHost.hashCode() ^ thisPort) + thisMemberIdHashCode : thisPort + thisMemberIdHashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GridProfileId) {
                GridProfileId other = (GridProfileId)obj;
                if (this.gp.getPort() == other.gp.getPort()) {
                    String thisHost = this.gp.getHost();
                    String otherHost = other.gp.getHost();
                    if (thisHost != null) {
                        if (thisHost.equals(otherHost)) {
                            if (this.getMemberId() != null) {
                                return this.getMemberId().getUniqueId().equals(other.getMemberId().getUniqueId());
                            }
                            return other.getMemberId() == null;
                        }
                    } else {
                        return otherHost == null;
                    }
                }
            }
            return false;
        }
    }

    public static abstract class GridProfile
    extends DistributionAdvisor.Profile {
        private String host;
        private int port;
        private DistributionAdvisor.ProfileId id;

        public GridProfile() {
        }

        public GridProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public GridProfile(GridProfile toCopy) {
            super(toCopy.getDistributedMember(), toCopy.version);
            this.host = toCopy.host;
            this.port = toCopy.port;
            this.finishInit();
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public DistributionAdvisor.ProfileId getId() {
            if (this.id == null) {
                throw new IllegalStateException("profile id not yet initialized");
            }
            return this.id;
        }

        protected void tellLocalControllers(boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            List<Locator> locators = Locator.getLocators();
            for (Locator locator : locators) {
                InternalLocator l = (InternalLocator)locator;
                ServerLocator advisee = l.getServerLocatorAdvisee();
                if (advisee != null && advisee.getProfile().equals(this)) continue;
                if (this.port > 0) {
                    this.handleDistributionAdvisee(advisee, removeProfile, exchangeProfiles, replyProfiles);
                    continue;
                }
                if (!exchangeProfiles || advisee == null) continue;
                replyProfiles.add(advisee.getProfile());
            }
        }

        protected void tellLocalBridgeServers(InternalCache cache, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            if (cache != null && !cache.isClosed()) {
                List<InternalCacheServer> bridgeServers = cache.getCacheServersAndGatewayReceiver();
                for (InternalCacheServer bridgeServer : bridgeServers) {
                    CacheServerImpl bsi = (CacheServerImpl)bridgeServer;
                    if (!bsi.isRunning() || bsi.getProfile().equals(this)) continue;
                    if (this.port > 0) {
                        this.handleDistributionAdvisee(bsi, removeProfile, exchangeProfiles, replyProfiles);
                        continue;
                    }
                    if (!exchangeProfiles) continue;
                    replyProfiles.add(bsi.getProfile());
                }
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeString(this.host, out);
            DataSerializer.writePrimitiveInt(this.port, out);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.host = DataSerializer.readString(in);
            this.port = DataSerializer.readPrimitiveInt(in);
            this.finishInit();
        }

        public void finishInit() {
            this.id = new GridProfileId(this);
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; host=").append(this.host);
            sb.append("; port=").append(this.port);
        }
    }
}

