/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.unsafe.RegisterSignalHandlerSupport;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.lang.utils.ClassUtils;
import org.apache.geode.internal.membership.utils.AvailablePort;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.SunAPINotFoundException;
import org.apache.geode.logging.internal.OSProcess;

public abstract class AbstractLauncher<T extends Comparable<T>>
implements Runnable {
    public static final String MEMBER_NAME_ERROR_MESSAGE = "The member name of the %s must be provided as an argument to the launcher, or a path to gemfire.properties must be specified, which assumes the %s member name will be set using the name property.";
    public static final String WORKING_DIRECTORY_OPTION_NOT_VALID_ERROR_MESSAGE = "Specifying the --dir option is not valid when starting a %s with the %sLauncher.";
    public static final String WORKING_DIRECTORY_NOT_FOUND_ERROR_MESSAGE = "The working directory for the %s could not be found.";
    @Immutable
    protected static final Boolean DEFAULT_FORCE = Boolean.FALSE;
    @Deprecated
    protected static final long READ_PID_FILE_TIMEOUT_MILLIS = 2000L;
    public static final String DEFAULT_WORKING_DIRECTORY = SystemUtils.CURRENT_DIRECTORY;
    public static final String SIGNAL_HANDLER_REGISTRATION_SYSTEM_PROPERTY = "gemfire.launcher.registerSignalHandlers";
    protected static final String OPTION_PREFIX = "-";
    private static final String SUN_SIGNAL_API_CLASS_NAME = "sun.misc.Signal";
    private volatile boolean debug;
    protected final transient AtomicBoolean running = new AtomicBoolean(false);
    @Deprecated
    protected Logger logger = Logger.getLogger(this.getClass().getName());

    public AbstractLauncher() {
        try {
            if (Boolean.getBoolean(SIGNAL_HANDLER_REGISTRATION_SYSTEM_PROPERTY)) {
                ClassUtils.forName((String)SUN_SIGNAL_API_CLASS_NAME, (RuntimeException)new SunAPINotFoundException("WARNING!!! Not running a Sun JVM.  Could not find the sun.misc.Signal class; Signal handling disabled."));
                RegisterSignalHandlerSupport.registerSignalHandlers();
            }
        }
        catch (SunAPINotFoundException handled) {
            this.info(handled.getMessage(), new Object[0]);
        }
    }

    protected static void assertPortAvailable(int port) throws BindException {
        AbstractLauncher.assertPortAvailable(null, port);
    }

    protected static void assertPortAvailable(InetAddress bindAddress, int port) throws BindException {
        if (!AvailablePort.isPortAvailable((int)port, (int)0, (InetAddress)bindAddress)) {
            throw new BindException(String.format("Network is unreachable; port (%1$d) is not available on %2$s.", port, bindAddress != null ? bindAddress.getCanonicalHostName() : "localhost"));
        }
    }

    protected static boolean isSet(Properties properties, String propertyName) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)properties.getProperty(propertyName));
    }

    protected static Properties loadGemFireProperties(URL url) {
        if (url == null) {
            return new Properties();
        }
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(new File(url.toURI()));){
            properties.load(reader);
        }
        catch (IOException | URISyntaxException handled) {
            AbstractLauncher.loadGemFirePropertiesFromClassPath(properties);
        }
        return properties;
    }

    private static void loadGemFirePropertiesFromClassPath(Properties properties) {
        try {
            properties.load(AbstractLauncher.class.getResourceAsStream(DistributedSystem.getPropertiesFile()));
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected Properties getDistributedSystemProperties() {
        return this.getDistributedSystemProperties(null);
    }

    protected Properties getDistributedSystemProperties(Properties defaults) {
        Properties distributedSystemProperties = new Properties();
        if (defaults != null) {
            distributedSystemProperties.putAll((Map<?, ?>)defaults);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getMemberName())) {
            distributedSystemProperties.setProperty("name", this.getMemberName());
        }
        return distributedSystemProperties;
    }

    protected File getLogFile() {
        return new File(this.getWorkingDirectory(), this.getLogFileName());
    }

    protected String getLogFileCanonicalPath() {
        try {
            return this.getLogFile().getCanonicalPath();
        }
        catch (IOException handled) {
            return this.getLogFileName();
        }
    }

    public abstract String getLogFileName();

    public String getMember() {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getMemberName())) {
            return this.getMemberName();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getMemberId())) {
            return this.getMemberId();
        }
        return null;
    }

    public String getMemberId() {
        InternalDistributedSystem distributedSystem = InternalDistributedSystem.getConnectedInstance();
        return distributedSystem != null ? distributedSystem.getMemberId() : null;
    }

    public String getMemberName() {
        InternalDistributedSystem distributedSystem = InternalDistributedSystem.getConnectedInstance();
        return distributedSystem != null ? distributedSystem.getConfig().getName() : null;
    }

    public abstract Integer getPid();

    public abstract String getServiceName();

    public String getWorkingDirectory() {
        return DEFAULT_WORKING_DIRECTORY;
    }

    protected void debug(String message, Object ... args) {
        if (this.isDebugging()) {
            if (args != null && args.length > 0) {
                System.err.printf(message, args);
            } else {
                System.err.print(message);
            }
        }
    }

    protected void debug(Throwable t) {
        if (this.isDebugging()) {
            t.printStackTrace(System.err);
        }
    }

    protected void info(Object message, Object ... args) {
        if (args != null && args.length > 0) {
            System.err.printf(message.toString(), args);
        } else {
            System.err.print(message);
        }
    }

    protected void redirectOutput(DistributedSystem distributedSystem) throws IOException {
        if (distributedSystem instanceof InternalDistributedSystem) {
            OSProcess.redirectOutput((File)((InternalDistributedSystem)distributedSystem).getConfig().getLogFile());
        }
    }

    public String version() {
        return GemFireVersion.getGemFireVersion();
    }

    int identifyPid() throws PidUnavailableException {
        return ProcessUtils.identifyPid();
    }

    int identifyPidOrNot() {
        try {
            return this.identifyPid();
        }
        catch (PidUnavailableException handled) {
            return -1;
        }
    }

    boolean isPidInProcess() {
        Integer pid = this.getPid();
        return pid != null && pid.intValue() == this.identifyPidOrNot();
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NOT_RESPONDING = new Status("not responding");
        public static final /* enum */ Status ONLINE = new Status("online");
        public static final /* enum */ Status STARTING = new Status("starting");
        public static final /* enum */ Status STOPPED = new Status("stopped");
        private final String description;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private Status(String description) {
            assert (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)description)) : "The Status description must be specified!";
            this.description = org.apache.commons.lang3.StringUtils.lowerCase((String)description);
        }

        public static Status valueOfDescription(String description) {
            for (Status status : Status.values()) {
                if (!status.getDescription().equalsIgnoreCase(description)) continue;
                return status;
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getDescription();
        }

        static {
            $VALUES = new Status[]{NOT_RESPONDING, ONLINE, STARTING, STOPPED};
        }
    }

    public static abstract class ServiceState<T extends Comparable<T>> {
        protected static final String JSON_CLASSPATH = "classpath";
        protected static final String JSON_GEMFIREVERSION = "gemFireVersion";
        protected static final String JSON_HOST = "bindAddress";
        protected static final String JSON_JAVAVERSION = "javaVersion";
        protected static final String JSON_JVMARGUMENTS = "jvmArguments";
        protected static final String JSON_LOCATION = "location";
        protected static final String JSON_LOGFILE = "logFileName";
        protected static final String JSON_MEMBERNAME = "memberName";
        protected static final String JSON_PID = "pid";
        protected static final String JSON_PORT = "port";
        protected static final String JSON_STATUS = "status";
        protected static final String JSON_STATUSMESSAGE = "statusMessage";
        protected static final String JSON_TIMESTAMP = "timestamp";
        protected static final String JSON_UPTIME = "uptime";
        protected static final String JSON_WORKINGDIRECTORY = "workingDirectory";
        static final String TO_STRING_PROCESS_ID = "Process ID: ";
        static final String TO_STRING_JAVA_VERSION = "Java Version: ";
        static final String TO_STRING_LOG_FILE = "Log File: ";
        static final String TO_STRING_JVM_ARGUMENTS = "JVM Arguments: ";
        static final String TO_STRING_CLASS_PATH = "Class-Path: ";
        static final String TO_STRING_UPTIME = "Uptime: ";
        static final String TO_STRING_GEODE_VERSION = "Geode Version: ";
        private static final String DATE_TIME_FORMAT_PATTERN = "MM/dd/yyyy hh:mm a";
        private final Integer pid;
        private final List<String> jvmArguments;
        private final Long uptime;
        private final Status status;
        private final String classpath;
        private final String gemfireVersion;
        private final String host;
        private final String javaVersion;
        private final String logFile;
        private final String memberName;
        private final String port;
        private final String serviceLocation;
        private final String statusMessage;
        private final String workingDirectory;
        private final Timestamp timestamp;

        protected static String format(Date timestamp) {
            return timestamp == null ? "" : new SimpleDateFormat(DATE_TIME_FORMAT_PATTERN).format(timestamp);
        }

        protected static Integer identifyPid() {
            try {
                return ProcessUtils.identifyPid();
            }
            catch (PidUnavailableException handled) {
                return null;
            }
        }

        protected static String toDaysHoursMinutesSeconds(Long milliseconds) {
            StringBuilder buffer = new StringBuilder();
            if (milliseconds != null) {
                long millisecondsRemaining = milliseconds;
                long days = TimeUnit.MILLISECONDS.toDays(millisecondsRemaining);
                long hours = TimeUnit.MILLISECONDS.toHours(millisecondsRemaining -= TimeUnit.DAYS.toMillis(days));
                long minutes = TimeUnit.MILLISECONDS.toMinutes(millisecondsRemaining -= TimeUnit.HOURS.toMillis(hours));
                long seconds = TimeUnit.MILLISECONDS.toSeconds(millisecondsRemaining -= TimeUnit.MINUTES.toMillis(minutes));
                if (days > 0L) {
                    buffer.append(days).append(days > 1L ? " days " : " day ");
                }
                if (hours > 0L) {
                    buffer.append(hours).append(hours > 1L ? " hours " : " hour ");
                }
                if (minutes > 0L) {
                    buffer.append(minutes).append(minutes > 1L ? " minutes " : " minute ");
                }
                buffer.append(seconds).append(seconds == 0L || seconds > 1L ? " seconds" : " second");
            }
            return buffer.toString();
        }

        protected ServiceState(Status status, String statusMessage, long timestamp, String serviceLocation, Integer pid, Long uptime, String workingDirectory, List<String> jvmArguments, String classpath, String gemfireVersion, String javaVersion, String logFile, String host, String port, String memberName) {
            assert (status != null) : "The status of the GemFire service cannot be null!";
            this.status = status;
            this.statusMessage = statusMessage;
            this.timestamp = new Timestamp(timestamp);
            this.serviceLocation = serviceLocation;
            this.pid = pid;
            this.uptime = uptime;
            this.workingDirectory = workingDirectory;
            this.jvmArguments = Collections.unmodifiableList(jvmArguments);
            this.classpath = classpath;
            this.gemfireVersion = gemfireVersion;
            this.javaVersion = javaVersion;
            this.logFile = logFile;
            this.host = host;
            this.port = port;
            this.memberName = memberName;
        }

        public String toJson() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(JSON_CLASSPATH, this.getClasspath());
            map.put(JSON_GEMFIREVERSION, this.getGemFireVersion());
            map.put(JSON_HOST, this.getHost());
            map.put(JSON_JAVAVERSION, this.getJavaVersion());
            map.put(JSON_JVMARGUMENTS, this.getJvmArguments());
            map.put(JSON_LOCATION, this.getServiceLocation());
            map.put(JSON_LOGFILE, this.getLogFile());
            map.put(JSON_MEMBERNAME, this.getMemberName());
            map.put(JSON_PID, this.getPid());
            map.put(JSON_PORT, this.getPort());
            map.put(JSON_STATUS, this.getStatus().getDescription());
            map.put(JSON_STATUSMESSAGE, this.getStatusMessage());
            map.put(JSON_TIMESTAMP, this.getTimestamp().getTime());
            map.put(JSON_UPTIME, this.getUptime());
            map.put(JSON_WORKINGDIRECTORY, this.getWorkingDirectory());
            String jsonStatus = null;
            try {
                jsonStatus = new ObjectMapper().writeValueAsString(map);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return jsonStatus;
        }

        public static boolean isStartingNotRespondingOrNull(ServiceState serviceState) {
            return serviceState == null || serviceState.isStartingOrNotResponding();
        }

        public boolean isStartingOrNotResponding() {
            return Status.NOT_RESPONDING == this.getStatus() || Status.STARTING == this.getStatus();
        }

        public boolean isVmWithProcessIdRunning() {
            return ProcessUtils.isProcessAlive(this.getPid());
        }

        public String getClasspath() {
            return this.classpath;
        }

        public String getGemFireVersion() {
            return this.gemfireVersion;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public List<String> getJvmArguments() {
            return this.jvmArguments;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public Integer getPid() {
            return this.pid;
        }

        public String getServiceLocation() {
            return this.serviceLocation;
        }

        protected abstract String getServiceName();

        public Status getStatus() {
            return this.status;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Timestamp getTimestamp() {
            return (Timestamp)this.timestamp.clone();
        }

        public Long getUptime() {
            return this.uptime;
        }

        public String getWorkingDirectory() {
            return this.workingDirectory != null ? this.workingDirectory : DEFAULT_WORKING_DIRECTORY;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.getStatus()) {
                case STARTING: {
                    sb.append("Starting %s in %s on %s as %s at %s").append(System.lineSeparator());
                    sb.append(TO_STRING_PROCESS_ID).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_JAVA_VERSION).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_LOG_FILE).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_JVM_ARGUMENTS).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_CLASS_PATH).append("%s");
                    return String.format(sb.toString(), this.getServiceName(), this.getWorkingDirectory(), this.getServiceLocation(), this.getMemberName(), this.toString(this.getTimestamp()), this.toString(this.getPid()), this.toString(this.getGemFireVersion()), this.toString(this.getJavaVersion()), this.getLogFile(), ArgumentRedactor.redact(this.getJvmArguments()), this.toString(this.getClasspath()));
                }
                case ONLINE: {
                    sb.append("%s in %s on %s as %s is currently %s.").append(System.lineSeparator());
                    sb.append(TO_STRING_PROCESS_ID).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_UPTIME).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_GEODE_VERSION).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_JAVA_VERSION).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_LOG_FILE).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_JVM_ARGUMENTS).append("%s").append(System.lineSeparator());
                    sb.append(TO_STRING_CLASS_PATH).append("%s");
                    return String.format(sb.toString(), new Object[]{this.getServiceName(), this.getWorkingDirectory(), this.getServiceLocation(), this.getMemberName(), this.getStatus(), this.toString(this.getPid()), ServiceState.toDaysHoursMinutesSeconds(this.getUptime()), this.toString(this.getGemFireVersion()), this.toString(this.getJavaVersion()), this.getLogFile(), ArgumentRedactor.redact(this.getJvmArguments()), this.toString(this.getClasspath())});
                }
                case STOPPED: {
                    sb.append("%s in %s on %s has been requested to stop.");
                    return String.format(sb.toString(), this.getServiceName(), this.getWorkingDirectory(), this.getServiceLocation());
                }
            }
            sb.append("%s in %s on %s is currently %s.");
            return String.format(sb.toString(), new Object[]{this.getServiceName(), this.getWorkingDirectory(), this.getServiceLocation(), this.getStatus()});
        }

        protected String toString(Date dateTime) {
            return ServiceState.format(dateTime);
        }

        protected String toString(Number value) {
            return StringUtils.defaultString(value);
        }

        protected String toString(Object ... values) {
            return values == null ? "" : org.apache.commons.lang3.StringUtils.join((Object[])values, (String)" ");
        }

        protected String toString(String value) {
            return value != null ? value : "";
        }
    }
}

