/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.IndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.RawIndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.PartitionedRegion;

public class RawLuceneRepositoryManager
extends PartitionedRepositoryManager {
    public static IndexRepositoryFactory indexRepositoryFactory = new RawIndexRepositoryFactory();

    public RawLuceneRepositoryManager(LuceneIndexImpl index, LuceneSerializer serializer, ExecutorService waitingThreadPool) {
        super(index, serializer, waitingThreadPool);
    }

    @Override
    protected IndexRepository getRepository(Integer bucketId) throws BucketNotFoundException {
        IndexRepository repo = (IndexRepository)this.indexRepositories.get(bucketId);
        if (repo != null && !repo.isClosed()) {
            return repo;
        }
        repo = this.computeRepository(bucketId);
        return repo;
    }

    @Override
    public IndexRepository computeRepository(Integer bucketId, LuceneSerializer serializer, InternalLuceneIndex index, PartitionedRegion userRegion, IndexRepository oldRepository) throws IOException {
        return indexRepositoryFactory.computeIndexRepository(bucketId, serializer, index, userRegion, oldRepository, this);
    }
}

