/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1WebhookConversion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceConversion describes how to convert different versions of a CR.")
public class V1CustomResourceConversion {
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    private String strategy;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private V1WebhookConversion webhook;

    public V1CustomResourceConversion strategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    @ApiModelProperty(required=true, value="strategy specifies how custom resources are converted between versions. Allowed values are: - `\"None\"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `\"Webhook\"`: API Server will call to an external webhook to do the conversion. Additional information   is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.")
    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public V1CustomResourceConversion webhook(V1WebhookConversion webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1WebhookConversion getWebhook() {
        return this.webhook;
    }

    public void setWebhook(V1WebhookConversion webhook) {
        this.webhook = webhook;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceConversion v1CustomResourceConversion = (V1CustomResourceConversion)o;
        return Objects.equals(this.strategy, v1CustomResourceConversion.strategy) && Objects.equals(this.webhook, v1CustomResourceConversion.webhook);
    }

    public int hashCode() {
        return Objects.hash(this.strategy, this.webhook);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceConversion {\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

