/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.destination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.MSQSelectDestination;
import org.apache.druid.msq.indexing.destination.SegmentGenerationStageSpec;
import org.apache.druid.msq.indexing.destination.TerminalStageSpec;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.security.Resource;
import org.joda.time.Interval;

public class DataSourceMSQDestination
implements MSQDestination {
    public static final String TYPE = "dataSource";
    private final String dataSource;
    private final Granularity segmentGranularity;
    private final List<String> segmentSortOrder;
    @Nullable
    private final List<Interval> replaceTimeChunks;
    private final TerminalStageSpec terminalStageSpec;
    @Nullable
    private final Map<String, DimensionSchema> dimensionSchemas;
    @Nullable
    private final List<AggregateProjectionSpec> projections;

    @JsonCreator
    public DataSourceMSQDestination(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="segmentSortOrder") @Nullable List<String> segmentSortOrder, @JsonProperty(value="replaceTimeChunks") @Nullable List<Interval> replaceTimeChunks, @JsonProperty(value="dimensionSchemas") @Nullable Map<String, DimensionSchema> dimensionSchemas, @JsonProperty(value="projections") @Nullable List<AggregateProjectionSpec> projections, @JsonProperty(value="terminalStageSpec") @Nullable TerminalStageSpec terminalStageSpec) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)TYPE);
        this.segmentGranularity = (Granularity)Preconditions.checkNotNull((Object)segmentGranularity, (Object)"segmentGranularity");
        this.segmentSortOrder = segmentSortOrder != null ? segmentSortOrder : Collections.emptyList();
        this.replaceTimeChunks = replaceTimeChunks;
        this.dimensionSchemas = dimensionSchemas;
        this.projections = projections;
        this.terminalStageSpec = terminalStageSpec != null ? terminalStageSpec : SegmentGenerationStageSpec.instance();
        DataSourceMSQDestination.validateReplaceTimeChunksGranularityAligned(segmentGranularity, replaceTimeChunks);
        DataSchema.validateProjections(projections, (Granularity)segmentGranularity);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public TerminalStageSpec getTerminalStageSpec() {
        return this.terminalStageSpec;
    }

    @JsonProperty
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getSegmentSortOrder() {
        return this.segmentSortOrder;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Interval> getReplaceTimeChunks() {
        return this.replaceTimeChunks;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, DimensionSchema> getDimensionSchemas() {
        return this.dimensionSchemas;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AggregateProjectionSpec> getProjections() {
        return this.projections;
    }

    public boolean isReplaceTimeChunks() {
        return this.replaceTimeChunks != null;
    }

    @Override
    public long getRowsInTaskReport() {
        return 0L;
    }

    @Override
    public MSQSelectDestination toSelectDestination() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceMSQDestination that = (DataSourceMSQDestination)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.segmentGranularity, that.segmentGranularity) && Objects.equals(this.segmentSortOrder, that.segmentSortOrder) && Objects.equals(this.replaceTimeChunks, that.replaceTimeChunks) && Objects.equals(this.dimensionSchemas, that.dimensionSchemas) && Objects.equals(this.projections, that.projections) && Objects.equals(this.terminalStageSpec, that.terminalStageSpec);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.segmentGranularity, this.segmentSortOrder, this.replaceTimeChunks, this.dimensionSchemas, this.projections, this.terminalStageSpec);
    }

    public String toString() {
        return "DataSourceMSQDestination{dataSource='" + this.dataSource + "', segmentGranularity=" + String.valueOf(this.segmentGranularity) + ", segmentSortOrder=" + String.valueOf(this.segmentSortOrder) + ", replaceTimeChunks=" + String.valueOf(this.replaceTimeChunks) + ", dimensionSchemas=" + String.valueOf(this.dimensionSchemas) + ", projections=" + String.valueOf(this.projections) + ", terminalStageSpec=" + String.valueOf(this.terminalStageSpec) + "}";
    }

    @Override
    public ShuffleSpecFactory getShuffleSpecFactory(int targetSize) {
        return ShuffleSpecFactories.getGlobalSortWithTargetSize(targetSize);
    }

    @Override
    public Optional<Resource> getDestinationResource() {
        return Optional.of(new Resource(this.getDataSource(), "DATASOURCE"));
    }

    private static void validateReplaceTimeChunksGranularityAligned(Granularity segmentGranularity, @Nullable List<Interval> replaceTimeChunks) {
        if (replaceTimeChunks != null) {
            if (replaceTimeChunks.isEmpty()) {
                throw new IAE("replaceTimeChunks must be null or nonempty; cannot be empty", new Object[0]);
            }
            for (Interval interval : replaceTimeChunks) {
                boolean endIsAligned;
                if (Intervals.ETERNITY.equals((Object)interval)) continue;
                boolean startIsAligned = segmentGranularity.bucketStart(interval.getStart()).equals((Object)interval.getStart());
                boolean bl = endIsAligned = segmentGranularity.bucketStart(interval.getEnd()).equals((Object)interval.getEnd()) || segmentGranularity.increment(segmentGranularity.bucketStart(interval.getEnd())).equals((Object)interval.getEnd());
                if (startIsAligned && endIsAligned) continue;
                throw new IAE("Time chunk [%s] provided in replaceTimeChunks is not aligned with segmentGranularity [%s]", new Object[]{interval, segmentGranularity});
            }
        }
    }
}

