/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.NotEnoughMemoryFault;

public class ControllerMemoryParameters {
    private static final long PARTITION_STATS_MAX_MEMORY = 300000000L;
    private static final long PARTITION_STATS_MIN_MEMORY = 25000000L;
    private final int partitionStatisticsMaxRetainedBytes;

    public ControllerMemoryParameters(int partitionStatisticsMaxRetainedBytes) {
        this.partitionStatisticsMaxRetainedBytes = partitionStatisticsMaxRetainedBytes;
    }

    public static ControllerMemoryParameters createProductionInstance(MemoryIntrospector memoryIntrospector, int maxWorkerCount) {
        long memoryForInputChannels;
        long totalMemory = memoryIntrospector.memoryPerTask();
        int partitionStatisticsMaxRetainedBytes = (int)Math.min(totalMemory - (memoryForInputChannels = WorkerMemoryParameters.computeProcessorMemoryForInputChannels(maxWorkerCount, 1000000)), 300000000L);
        if ((long)partitionStatisticsMaxRetainedBytes < 25000000L) {
            long requiredTaskMemory = memoryForInputChannels + 25000000L;
            throw new MSQException(new NotEnoughMemoryFault(memoryIntrospector.computeJvmMemoryRequiredForTaskMemory(requiredTaskMemory), memoryIntrospector.totalMemoryInJvm(), memoryIntrospector.memoryPerTask(), memoryIntrospector.numTasksInJvm(), memoryIntrospector.numProcessingThreads(), maxWorkerCount, 1));
        }
        return new ControllerMemoryParameters(partitionStatisticsMaxRetainedBytes);
    }

    public int getPartitionStatisticsMaxRetainedBytes() {
        return this.partitionStatisticsMaxRetainedBytes;
    }
}

