/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchModule;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchUnaryPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class ArrayOfDoublesSketchToQuantilesSketchPostAggregator
extends ArrayOfDoublesSketchUnaryPostAggregator {
    private static final int DEFAULT_QUANTILES_SKETCH_SIZE = 128;
    private final int column;
    private final int k;

    @JsonCreator
    public ArrayOfDoublesSketchToQuantilesSketchPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="column") @Nullable Integer column, @JsonProperty(value="k") @Nullable Integer k) {
        super(name, field);
        this.column = column == null ? 1 : column;
        this.k = k == null ? 128 : k;
    }

    public Comparator<DoublesSketch> getComparator() {
        return DoublesSketchAggregatorFactory.COMPARATOR;
    }

    public DoublesSketch compute(Map<String, Object> combinedAggregators) {
        ArrayOfDoublesSketch sketch = (ArrayOfDoublesSketch)this.getField().compute(combinedAggregators);
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(this.k).build();
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            qs.update(it.getValues()[this.column - 1]);
        }
        return qs;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(40).appendCacheable((Cacheable)this.getField()).appendInt(this.column).appendInt(this.k).build();
    }

    public ColumnType getType(ColumnInspector signature) {
        return ArrayOfDoublesSketchModule.MERGE_TYPE;
    }

    @JsonProperty
    public int getColumn() {
        return this.column;
    }

    @JsonProperty
    public int getK() {
        return this.k;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.getName() + "', field=" + String.valueOf(this.getField()) + ", column=" + this.column + ", k=" + this.k + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayOfDoublesSketchToQuantilesSketchPostAggregator that = (ArrayOfDoublesSketchToQuantilesSketchPostAggregator)o;
        return this.column == that.column && this.k == that.k;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.column, this.k);
    }
}

