/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic;

import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import java.util.Objects;

public class GenericEntry
implements MutableBucketEntry {
    private final Version backwardCompatibilityVersion;
    private RemoteBucketState originalState;
    private RemoteBucketState modifiedState;

    public GenericEntry(byte[] originalStateBytes, Version backwardCompatibilityVersion) {
        this.backwardCompatibilityVersion = backwardCompatibilityVersion;
        this.originalState = originalStateBytes == null ? null : InternalSerializationHelper.deserializeState(originalStateBytes);
    }

    @Override
    public boolean exists() {
        return this.originalState != null;
    }

    @Override
    public void set(RemoteBucketState state) {
        this.modifiedState = state;
    }

    @Override
    public RemoteBucketState get() {
        return Objects.requireNonNull(this.originalState);
    }

    public RemoteBucketState getModifiedState() {
        return this.modifiedState;
    }

    public byte[] getModifiedStateBytes() {
        return InternalSerializationHelper.serializeState(this.modifiedState, this.backwardCompatibilityVersion);
    }

    public boolean isModified() {
        return this.modifiedState != null;
    }
}

