/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.druid.data.input.azure.AzureEntityFactory;
import org.apache.druid.data.input.azure.AzureInputSource;
import org.apache.druid.data.input.azure.AzureStorageAccountInputSource;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureByteSourceFactory;
import org.apache.druid.storage.azure.AzureClientFactory;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureCloudBlobIteratorFactory;
import org.apache.druid.storage.azure.AzureDataSegmentConfig;
import org.apache.druid.storage.azure.AzureDataSegmentKiller;
import org.apache.druid.storage.azure.AzureDataSegmentPusher;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureLoadSpec;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureTaskLogs;
import org.apache.druid.storage.azure.AzureTaskLogsConfig;

public class AzureStorageDruidModule
implements DruidModule {
    public static final String SCHEME = "azure";
    public static final String INDEX_ZIP_FILE_NAME = "index.zip";

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidAzure-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{AzureLoadSpec.class});
            }
        }, (Object)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(AzureInputSource.class, SCHEME), new NamedType(AzureStorageAccountInputSource.class, "azureStorage")}));
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.azure", AzureInputDataConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.azure", AzureDataSegmentConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.azure", AzureAccountConfig.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(AzureDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(AzureDataSegmentKiller.class).in(LazySingleton.class);
        Binders.taskLogsBinder((Binder)binder).addBinding((Object)SCHEME).to(AzureTaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", AzureTaskLogsConfig.class);
        binder.bind(AzureTaskLogs.class).in(LazySingleton.class);
        binder.install(new FactoryModuleBuilder().build(AzureByteSourceFactory.class));
        binder.install(new FactoryModuleBuilder().build(AzureEntityFactory.class));
        binder.install(new FactoryModuleBuilder().build(AzureCloudBlobIteratorFactory.class));
        binder.install(new FactoryModuleBuilder().build(AzureCloudBlobIterableFactory.class));
    }

    @Provides
    @LazySingleton
    public AzureClientFactory getAzureClientFactory(AzureAccountConfig config) {
        if (StringUtils.isEmpty((CharSequence)config.getAccount())) {
            throw new ISE("Set 'account' to the storage account that needs to be configured in the azure config. Please refer to azure documentation.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)config.getKey()) && StringUtils.isEmpty((CharSequence)config.getSharedAccessStorageToken()) && BooleanUtils.isNotTrue((Boolean)config.getUseAzureCredentialsChain())) {
            throw new ISE("Either set 'key' or 'sharedAccessStorageToken' or 'useAzureCredentialsChain' in the azure config. Please refer to azure documentation.", new Object[0]);
        }
        if (!StringUtils.isEmpty((CharSequence)config.getKey()) && !StringUtils.isEmpty((CharSequence)config.getSharedAccessStorageToken()) || !StringUtils.isEmpty((CharSequence)config.getKey()) && BooleanUtils.isTrue((Boolean)config.getUseAzureCredentialsChain()) || !StringUtils.isEmpty((CharSequence)config.getSharedAccessStorageToken()) && BooleanUtils.isTrue((Boolean)config.getUseAzureCredentialsChain())) {
            throw new ISE("Set only one of 'key' or 'sharedAccessStorageToken' or 'useAzureCredentialsChain' in the azure config. Please refer to azure documentation.", new Object[0]);
        }
        return new AzureClientFactory(config);
    }

    @Provides
    @Global
    @LazySingleton
    public AzureStorage getAzureStorageContainer(AzureClientFactory azureClientFactory, AzureAccountConfig azureAccountConfig) {
        return new AzureStorage(azureClientFactory, azureAccountConfig.getAccount());
    }
}

