/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class LdifUtils {
    public static byte[] utf8encode(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s.getBytes();
        }
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    public static String base64encode(byte[] b) {
        return LdifUtils.utf8decode(Base64.encodeBase64((byte[])b));
    }

    public static String hexEncode(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] c = Hex.encodeHex((byte[])data);
        String s = new String(c);
        return s;
    }

    public static String utf8decode(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(b);
        }
    }

    public static byte[] base64decodeToByteArray(String s) {
        return Base64.decodeBase64((byte[])LdifUtils.utf8encode(s));
    }

    public static boolean mustEncodeDN(String dn) {
        return LdifUtils.mustEncode(dn);
    }

    public static boolean mustEncode(String value) {
        if (value == null || value.length() < 1) {
            return false;
        }
        if (value.startsWith(" ") || value.startsWith(":") || value.startsWith("<")) {
            return true;
        }
        if (value.endsWith(" ")) {
            return true;
        }
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) == '\r' || value.charAt(i) == '\n' || value.charAt(i) == '\u0000' || value.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String convertNlRcToString(String s) {
        if (s == null) {
            return "";
        }
        char[] result = new char[s.length() * 3];
        int pos = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                result[pos++] = 92;
                result[pos++] = 110;
            } else if (c == '\r') {
                result[pos++] = 92;
                result[pos++] = 114;
            } else {
                result[pos++] = c;
            }
            ++n2;
        }
        return new String(result, 0, pos);
    }
}

