/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CreateConnectionActionHelper {
    public static void createLdapBrowserConnection(LdapServer server, Connection connection) {
        ConnectionCorePlugin.getDefault().getConnectionManager().addConnection(connection);
        ConnectionCorePlugin.getDefault().getConnectionFolderManager().getRootConnectionFolder().addConnectionId(connection.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor ldapPerspective = CreateConnectionActionHelper.getLdapPerspective();
        IPerspectiveDescriptor currentPerspective = window.getActivePage().getPerspective();
        if (ldapPerspective != null && ldapPerspective.equals(currentPerspective)) {
            MessageDialog dialog = new MessageDialog(window.getShell(), Messages.getString("CreateConnectionActionHelper.ConnectionCreated"), null, NLS.bind((String)Messages.getString("CreateConnectionActionHelper.ConnectionCalledCreated"), (Object[])new String[]{connection.getName()}), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
        } else {
            MessageDialog dialog = new MessageDialog(window.getShell(), Messages.getString("CreateConnectionActionHelper.ConnectionCreated"), null, NLS.bind((String)Messages.getString("CreateConnectionActionHelper.ConnectionCalledCreatedSwitch"), (Object[])new String[]{connection.getName()}), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dialog.open() == 0) {
                window.getActivePage().setPerspective(ldapPerspective);
            }
        }
    }

    private static IPerspectiveDescriptor getLdapPerspective() {
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            if ("org.apache.directory.studio.ldapbrowser.ui.perspective.BrowserPerspective".equalsIgnoreCase(perspective.getId())) {
                return perspective;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isLdapBrowserPluginsAvailable() {
        String[] bundleNames;
        String[] stringArray = bundleNames = new String[]{"org.apache.directory.studio.connection.core", "org.apache.directory.studio.connection.ui", "org.apache.directory.studio.ldapbrowser.common", "org.apache.directory.studio.ldapbrowser.core", "org.apache.directory.studio.ldapbrowser.ui", "org.apache.directory.studio.ldifeditor", "org.apache.directory.studio.ldifparser"};
        int n = bundleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null || bundle.getState() == 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

