/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.apacheds;

import java.io.File;
import java.util.ArrayList;
import org.apache.directory.server.config.beans.ChangePasswordServerBean;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.DnsServerBean;
import org.apache.directory.server.config.beans.KdcServerBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.NtpServerBean;
import org.apache.directory.server.config.beans.TransportBean;
import org.apache.directory.studio.apacheds.configuration.editor.Configuration;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.jobs.LoadConfigurationRunnable;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.filesystem.PathEditorInput;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.LdapServersUtils;
import org.apache.directory.studio.ldapservers.apacheds.ApacheDS200Plugin;
import org.apache.directory.studio.ldapservers.apacheds.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ApacheDS200LdapServerAdapter
implements LdapServerAdapter {
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String RESOURCES = "resources";
    private static final String LIBS = "libs";
    private static final String CONF = "conf";
    private static final String[] libraries = new String[]{"apacheds-service.jar"};

    public void add(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        Bundle bundle = ApacheDS200Plugin.getDefault().getBundle();
        LdapServersUtils.verifyAndCopyLibraries((Bundle)bundle, (IPath)new Path(RESOURCES).append(LIBS), (IPath)ApacheDS200LdapServerAdapter.getServerLibrariesFolder(), (String[])libraries, (StudioProgressMonitor)monitor, (String)Messages.getString("ApacheDS200LdapServerAdapter.VerifyingAndCopyingLibraries"));
        monitor.subTask(Messages.getString("ApacheDS200LdapServerAdapter.CreatingServerFolderStructure"));
        File serverFolder = LdapServersManager.getServerFolder((LdapServer)server).toFile();
        File confFolder = new File(serverFolder, CONF);
        confFolder.mkdir();
        File ldifFolder = new File(serverFolder, "ldif");
        ldifFolder.mkdir();
        File logFolder = new File(serverFolder, "log");
        logFolder.mkdir();
        File partitionFolder = new File(serverFolder, "partitions");
        partitionFolder.mkdir();
        monitor.subTask(Messages.getString("ApacheDS200LdapServerAdapter.CopyingConfigurationFiles"));
        IPath resourceConfFolderPath = new Path(RESOURCES).append(CONF);
        ApacheDS200LdapServerAdapter.getServerConfiguration(server);
        LdapServersUtils.copyResource((Bundle)bundle, (IPath)resourceConfFolderPath.append(LOG4J_PROPERTIES), (File)new File(confFolder, LOG4J_PROPERTIES));
        new File(logFolder, "apacheds.log").createNewFile();
    }

    public void delete(LdapServer server, StudioProgressMonitor monitor) throws Exception {
    }

    public void openConfiguration(final LdapServer server, final StudioProgressMonitor monitor) throws Exception {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PathEditorInput input = new PathEditorInput(LdapServersManager.getServerFolder((LdapServer)server).append(ApacheDS200LdapServerAdapter.CONF).append("ou=config.ldif"));
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, ServerConfigurationEditor.ID);
                }
                catch (PartInitException e) {
                    monitor.reportError((Exception)((Object)e));
                }
            }
        });
    }

    public void start(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        ILaunch launch = this.startOrRepair(server, monitor, Action.START);
        server.putCustomObject("launchConfiguration", (Object)launch);
        LdapServersUtils.runStartupListenerWatchdog((LdapServer)server, (int)this.getTestingPort(server));
    }

    public void repair(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        this.startOrRepair(server, monitor, Action.REPAIR);
        long startTime = System.currentTimeMillis();
        long watchDog = startTime + 180000L;
        do {
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() < watchDog && LdapServerStatus.REPAIRING == server.getStatus());
        LdapServersUtils.stopConsolePrinterThread((LdapServer)server);
    }

    private ILaunch startOrRepair(LdapServer server, StudioProgressMonitor monitor, Action action) throws Exception {
        Bundle bundle = ApacheDS200Plugin.getDefault().getBundle();
        LdapServersUtils.verifyAndCopyLibraries((Bundle)bundle, (IPath)new Path(RESOURCES).append(LIBS), (IPath)ApacheDS200LdapServerAdapter.getServerLibrariesFolder(), (String[])libraries, (StudioProgressMonitor)monitor, (String)Messages.getString("ApacheDS200LdapServerAdapter.VerifyingAndCopyingLibraries"));
        LdapServersUtils.startConsolePrinterThread((LdapServer)server, (File)LdapServersManager.getServerFolder((LdapServer)server).append("log").append("apacheds.log").toFile());
        ILaunch launch = ApacheDS200LdapServerAdapter.launchApacheDS(server, action);
        return launch;
    }

    private static ILaunch launchApacheDS(LdapServer server, Action action) throws Exception {
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, server.getId());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmInstall.getInstallLocation().toString());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.apache.directory.server.UberjarMain");
        ArrayList<String> classpath = new ArrayList<String>();
        String[] stringArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            String library = stringArray[n2];
            IRuntimeClasspathEntry libraryClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)ApacheDS200LdapServerAdapter.getServerLibrariesFolder().append(library));
            libraryClasspathEntry.setClasspathProperty(3);
            classpath.add(libraryClasspathEntry.getMemento());
            ++n2;
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        IPath serverFolderPath = LdapServersManager.getServerFolder((LdapServer)server);
        StringBuffer programArguments = new StringBuffer();
        programArguments.append("\"" + serverFolderPath.toOSString() + "\"");
        if (action == Action.REPAIR) {
            programArguments.append(" ");
            programArguments.append("\"repair\"");
        } else if (action == Action.STOP) {
            programArguments.append(" ");
            programArguments.append("\"stop\"");
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
        StringBuffer vmArguments = new StringBuffer();
        vmArguments.append("-Dlog4j.configuration=file:\"" + serverFolderPath.append(CONF).append(LOG4J_PROPERTIES).toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.var.dir=\"" + serverFolderPath.toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.log.dir=\"" + serverFolderPath.append("log").toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.instance=\"" + server.getName() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.controls=");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.extendedOperations=");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments.toString());
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute("org.eclipse.debug.core.capture_output", false);
        ILaunchConfiguration configuration = workingCopy.doSave();
        ILaunch launch = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        LdapServersUtils.startTerminateListenerThread((LdapServer)server, (ILaunch)launch);
        return launch;
    }

    public void stop(LdapServer server, StudioProgressMonitor monitor) throws Exception {
        ApacheDS200LdapServerAdapter.launchApacheDS(server, Action.STOP);
        long startTime = System.currentTimeMillis();
        long watchDog = startTime + 180000L;
        do {
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() < watchDog && LdapServerStatus.STOPPING == server.getStatus());
        LdapServersUtils.stopConsolePrinterThread((LdapServer)server);
        LdapServersUtils.terminateLaunchConfiguration((LdapServer)server);
    }

    private static IPath getServerLibrariesFolder() {
        return ApacheDS200Plugin.getDefault().getStateLocation().append(LIBS);
    }

    public static Configuration getServerConfiguration(LdapServer server) throws Exception {
        File configFile = LdapServersManager.getServerFolder((LdapServer)server).append(CONF).append("ou=config.ldif").toFile();
        return LoadConfigurationRunnable.readConfiguration((File)configFile);
    }

    private int getTestingPort(LdapServer server) throws Exception {
        ConfigBean configuration = ApacheDS200LdapServerAdapter.getServerConfiguration(server).getConfigBean();
        if (ApacheDS200LdapServerAdapter.isEnableLdap(configuration)) {
            return ApacheDS200LdapServerAdapter.getLdapPort(configuration);
        }
        if (ApacheDS200LdapServerAdapter.isEnableLdaps(configuration)) {
            return ApacheDS200LdapServerAdapter.getLdapsPort(configuration);
        }
        if (ApacheDS200LdapServerAdapter.isEnableKerberos(configuration)) {
            return ApacheDS200LdapServerAdapter.getKerberosPort(configuration);
        }
        if (ApacheDS200LdapServerAdapter.isEnableDns(configuration)) {
            return ApacheDS200LdapServerAdapter.getDnsPort(configuration);
        }
        if (ApacheDS200LdapServerAdapter.isEnableNtp(configuration)) {
            return ApacheDS200LdapServerAdapter.getNtpPort(configuration);
        }
        if (ApacheDS200LdapServerAdapter.isEnableChangePassword(configuration)) {
            return ApacheDS200LdapServerAdapter.getChangePasswordPort(configuration);
        }
        return 0;
    }

    public static boolean isEnableLdap(ConfigBean configuration) {
        TransportBean ldapServerTransportBean = ApacheDS200LdapServerAdapter.getLdapServerTransportBean(configuration);
        if (ldapServerTransportBean != null) {
            return ldapServerTransportBean.isEnabled();
        }
        return false;
    }

    public static boolean isEnableLdaps(ConfigBean configuration) {
        TransportBean ldapsServerTransportBean = ApacheDS200LdapServerAdapter.getLdapsServerTransportBean(configuration);
        if (ldapsServerTransportBean != null) {
            return ldapsServerTransportBean.isEnabled();
        }
        return false;
    }

    private static TransportBean getLdapServerTransportBean(ConfigBean configuration) {
        return ApacheDS200LdapServerAdapter.getLdapServerTransportBean(configuration, "ldap");
    }

    private static TransportBean getLdapsServerTransportBean(ConfigBean configuration) {
        return ApacheDS200LdapServerAdapter.getLdapServerTransportBean(configuration, "ldaps");
    }

    private static TransportBean getLdapServerTransportBean(ConfigBean configuration, String id) {
        TransportBean[] ldapServerTransportBeans;
        LdapServerBean ldapServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (ldapServerBean = directoryServiceBean.getLdapServerBean()) != null && (ldapServerTransportBeans = ldapServerBean.getTransports()) != null) {
            TransportBean[] transportBeanArray = ldapServerTransportBeans;
            int n = ldapServerTransportBeans.length;
            int n2 = 0;
            while (n2 < n) {
                TransportBean ldapServerTransportBean = transportBeanArray[n2];
                if (id.equals(ldapServerTransportBean.getTransportId())) {
                    return ldapServerTransportBean;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isEnableKerberos(ConfigBean configuration) {
        KdcServerBean kdcServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (kdcServerBean = directoryServiceBean.getKdcServerBean()) != null) {
            kdcServerBean.isEnabled();
        }
        return false;
    }

    public static boolean isEnableDns(ConfigBean configuration) {
        DnsServerBean dnsServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (dnsServerBean = directoryServiceBean.getDnsServerBean()) != null) {
            dnsServerBean.isEnabled();
        }
        return false;
    }

    public static boolean isEnableNtp(ConfigBean configuration) {
        NtpServerBean ntpServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (ntpServerBean = directoryServiceBean.getNtpServerBean()) != null) {
            ntpServerBean.isEnabled();
        }
        return false;
    }

    public static boolean isEnableChangePassword(ConfigBean configuration) {
        ChangePasswordServerBean changePasswordServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (changePasswordServerBean = directoryServiceBean.getChangePasswordServerBean()) != null) {
            changePasswordServerBean.isEnabled();
        }
        return false;
    }

    public static int getLdapPort(ConfigBean configuration) {
        TransportBean ldapServerTransportBean = ApacheDS200LdapServerAdapter.getLdapServerTransportBean(configuration);
        if (ldapServerTransportBean != null) {
            return ldapServerTransportBean.getSystemPort();
        }
        return 0;
    }

    public static int getLdapsPort(ConfigBean configuration) {
        TransportBean ldapsServerTransportBean = ApacheDS200LdapServerAdapter.getLdapsServerTransportBean(configuration);
        if (ldapsServerTransportBean != null) {
            return ldapsServerTransportBean.getSystemPort();
        }
        return 0;
    }

    public static int getKerberosPort(ConfigBean configuration) {
        TransportBean[] kdcServerTransportBeans;
        KdcServerBean kdcServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (kdcServerBean = directoryServiceBean.getKdcServerBean()) != null && (kdcServerTransportBeans = kdcServerBean.getTransports()) != null) {
            TransportBean[] transportBeanArray = kdcServerTransportBeans;
            int n = kdcServerTransportBeans.length;
            int n2 = 0;
            while (n2 < n) {
                TransportBean kdcServerTransportBean = transportBeanArray[n2];
                if ("tcp".equals(kdcServerTransportBean.getTransportId()) || "udp".equals(kdcServerTransportBean.getTransportId())) {
                    return kdcServerTransportBean.getSystemPort();
                }
                ++n2;
            }
        }
        return 0;
    }

    public static int getDnsPort(ConfigBean configuration) {
        TransportBean[] dnsServerTransportBeans;
        DnsServerBean dnsServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (dnsServerBean = directoryServiceBean.getDnsServerBean()) != null && (dnsServerTransportBeans = dnsServerBean.getTransports()) != null) {
            TransportBean[] transportBeanArray = dnsServerTransportBeans;
            int n = dnsServerTransportBeans.length;
            int n2 = 0;
            while (n2 < n) {
                TransportBean dnsServerTransportBean = transportBeanArray[n2];
                if ("tcp".equals(dnsServerTransportBean.getTransportId()) || "udp".equals(dnsServerTransportBean.getTransportId())) {
                    return dnsServerTransportBean.getSystemPort();
                }
                ++n2;
            }
        }
        return 0;
    }

    public static int getNtpPort(ConfigBean configuration) {
        TransportBean[] ntpServerTransportBeans;
        NtpServerBean ntpServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (ntpServerBean = directoryServiceBean.getNtpServerBean()) != null && (ntpServerTransportBeans = ntpServerBean.getTransports()) != null) {
            TransportBean[] transportBeanArray = ntpServerTransportBeans;
            int n = ntpServerTransportBeans.length;
            int n2 = 0;
            while (n2 < n) {
                TransportBean ntpServerTransportBean = transportBeanArray[n2];
                if ("tcp".equals(ntpServerTransportBean.getTransportId()) || "udp".equals(ntpServerTransportBean.getTransportId())) {
                    return ntpServerTransportBean.getSystemPort();
                }
                ++n2;
            }
        }
        return 0;
    }

    public static int getChangePasswordPort(ConfigBean configuration) {
        TransportBean[] changePasswordServerTransportBeans;
        ChangePasswordServerBean changePasswordServerBean;
        DirectoryServiceBean directoryServiceBean = configuration.getDirectoryServiceBean();
        if (directoryServiceBean != null && (changePasswordServerBean = directoryServiceBean.getChangePasswordServerBean()) != null && (changePasswordServerTransportBeans = changePasswordServerBean.getTransports()) != null) {
            TransportBean[] transportBeanArray = changePasswordServerTransportBeans;
            int n = changePasswordServerTransportBeans.length;
            int n2 = 0;
            while (n2 < n) {
                TransportBean changePasswordServerTransportBean = transportBeanArray[n2];
                if ("tcp".equals(changePasswordServerTransportBean.getTransportId()) || "udp".equals(changePasswordServerTransportBean.getTransportId())) {
                    return changePasswordServerTransportBean.getSystemPort();
                }
                ++n2;
            }
        }
        return 0;
    }

    public String[] checkPortsBeforeServerStart(LdapServer server) throws Exception {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        ConfigBean configuration = ApacheDS200LdapServerAdapter.getServerConfiguration(server).getConfigBean();
        if (ApacheDS200LdapServerAdapter.isEnableLdap(configuration) && !AvailablePortFinder.available((int)ApacheDS200LdapServerAdapter.getLdapPort(configuration))) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS200LdapServerAdapter.LDAPPort"), (Object[])new Object[]{ApacheDS200LdapServerAdapter.getLdapPort(configuration)}));
        }
        if (ApacheDS200LdapServerAdapter.isEnableLdaps(configuration) && !AvailablePortFinder.available((int)ApacheDS200LdapServerAdapter.getLdapsPort(configuration))) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS200LdapServerAdapter.LDAPSPort"), (Object[])new Object[]{ApacheDS200LdapServerAdapter.getLdapsPort(configuration)}));
        }
        if (ApacheDS200LdapServerAdapter.isEnableKerberos(configuration) && !AvailablePortFinder.available((int)ApacheDS200LdapServerAdapter.getKerberosPort(configuration))) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS200LdapServerAdapter.KerberosPort"), (Object[])new Object[]{ApacheDS200LdapServerAdapter.getKerberosPort(configuration)}));
        }
        if (ApacheDS200LdapServerAdapter.isEnableDns(configuration) && !AvailablePortFinder.available((int)ApacheDS200LdapServerAdapter.getDnsPort(configuration))) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS200LdapServerAdapter.DNSPort"), (Object[])new Object[]{ApacheDS200LdapServerAdapter.getDnsPort(configuration)}));
        }
        if (ApacheDS200LdapServerAdapter.isEnableNtp(configuration) && !AvailablePortFinder.available((int)ApacheDS200LdapServerAdapter.getNtpPort(configuration))) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS200LdapServerAdapter.NTPPort"), (Object[])new Object[]{ApacheDS200LdapServerAdapter.getNtpPort(configuration)}));
        }
        if (ApacheDS200LdapServerAdapter.isEnableChangePassword(configuration) && !AvailablePortFinder.available((int)ApacheDS200LdapServerAdapter.getChangePasswordPort(configuration))) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("ApacheDS200LdapServerAdapter.ChangePasswordPort"), (Object[])new Object[]{ApacheDS200LdapServerAdapter.getChangePasswordPort(configuration)}));
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    private static enum Action {
        START,
        REPAIR,
        STOP;

    }
}

