/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;

public class FilterCharacterPairMatcher
implements ICharacterPairMatcher {
    private LdapFilterParser parser;
    private int anchor;

    public FilterCharacterPairMatcher(ISourceViewer sourceViewer, LdapFilterParser parser) {
        this.parser = parser;
        this.clear();
    }

    public void dispose() {
    }

    public void clear() {
        this.anchor = 1;
    }

    public IRegion match(IDocument document, int offset) {
        LdapFilter filter;
        LdapFilter model = this.parser.getModel();
        if (model != null && (filter = this.parser.getModel().getFilter(offset - 1)) != null && filter.getStartToken() != null && filter.getStopToken() != null) {
            int left = filter.getStartToken().getOffset();
            int right = filter.getStopToken().getOffset();
            if (left == offset - 1) {
                this.anchor = 1;
                Region region = new Region(left, right - left + 1);
                return region;
            }
            if (right == offset - 1) {
                this.anchor = 0;
                Region region = new Region(left, right - left + 1);
                return region;
            }
        }
        return null;
    }

    public int getAnchor() {
        return this.anchor;
    }
}

