/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.BrowserActionProxy;
import org.apache.directory.studio.ldapbrowser.common.dnd.EntryTransfer;
import org.apache.directory.studio.ldapbrowser.common.dnd.SearchTransfer;
import org.apache.directory.studio.ldapbrowser.common.dnd.ValuesTransfer;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CopyAction
extends BrowserAction {
    private BrowserActionProxy pasteActionProxy;
    private ValueEditorManager valueEditorManager;

    public CopyAction(BrowserActionProxy pasteActionProxy) {
        this.pasteActionProxy = pasteActionProxy;
    }

    public CopyAction(BrowserActionProxy pasteActionProxy, ValueEditorManager valueEditorManager) {
        this.pasteActionProxy = pasteActionProxy;
        this.valueEditorManager = valueEditorManager;
    }

    @Override
    public String getText() {
        IEntry[] entries = this.getEntries();
        if (entries != null) {
            return entries.length > 1 ? Messages.getString("CopyAction.CopyEntriesDNs") : Messages.getString("CopyAction.CopyEntryDN");
        }
        ISearch[] searches = this.getSearches();
        if (searches != null) {
            return searches.length > 1 ? Messages.getString("CopyAction.CopySearches") : Messages.getString("CopyAction.CopySearch");
        }
        IValue[] values = this.getValues();
        if (values != null) {
            return values.length > 1 ? Messages.getString("CopyAction.CopyValues") : Messages.getString("CopyAction.CopyValue");
        }
        return Messages.getString("CopyAction.Copy");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.copy";
    }

    @Override
    public void run() {
        int i;
        StringBuffer text;
        IEntry[] entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IValue[] values = this.getValues();
        String[] stringProperties = this.getSelectedProperties();
        if (entries != null) {
            text = new StringBuffer();
            i = 0;
            while (i < entries.length) {
                text.append(entries[i].getDn().getName());
                if (i + 1 < entries.length) {
                    text.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                ++i;
            }
            CopyAction.copyToClipboard(new Object[]{entries, text.toString()}, new Transfer[]{EntryTransfer.getInstance(), TextTransfer.getInstance()});
        }
        if (searches != null) {
            CopyAction.copyToClipboard(new Object[]{searches}, new Transfer[]{SearchTransfer.getInstance()});
        } else if (values != null) {
            text = new StringBuffer();
            i = 0;
            while (i < values.length) {
                IValue value = values[i];
                if (this.valueEditorManager != null) {
                    IValueEditor ve = this.valueEditorManager.getCurrentValueEditor(value);
                    String displayValue = ve.getDisplayValue(value);
                    text.append(displayValue);
                } else if (values[i].isString()) {
                    text.append(values[i].getStringValue());
                } else if (values[i].isBinary()) {
                    text.append(LdifUtils.base64encode((byte[])values[i].getBinaryValue()));
                }
                if (i + 1 < values.length) {
                    text.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                ++i;
            }
            CopyAction.copyToClipboard(new Object[]{values, text.toString()}, new Transfer[]{ValuesTransfer.getInstance(), TextTransfer.getInstance()});
        } else if (stringProperties != null && stringProperties.length > 0) {
            text = new StringBuffer();
            i = 0;
            while (i < stringProperties.length) {
                text.append(stringProperties[i]);
                if (i + 1 < stringProperties.length) {
                    text.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                ++i;
            }
            CopyAction.copyToClipboard(new Object[]{text.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        if (this.pasteActionProxy != null) {
            this.pasteActionProxy.updateAction();
        }
    }

    public static void copyToClipboard(Object[] data, Transfer[] dataTypes) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            try {
                clipboard.setContents(data, dataTypes);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.getEntries() != null) {
            return true;
        }
        if (this.getSearches() != null) {
            return true;
        }
        if (this.getValues() != null) {
            return true;
        }
        return this.getSelectedProperties() != null && this.getSelectedProperties().length > 0;
    }

    private IEntry[] getEntries() {
        if (this.getSelectedConnections().length + this.getSelectedSearches().length + this.getSelectedAttributeHierarchies().length + this.getSelectedAttributes().length + this.getSelectedValues().length == 0 && this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length > 0) {
            LinkedHashSet<IEntry> entriesSet = new LinkedHashSet<IEntry>();
            IEntry[] iEntryArray = this.getSelectedEntries();
            int n = iEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEntry entry = iEntryArray[n2];
                entriesSet.add(entry);
                ++n2;
            }
            iEntryArray = this.getSelectedSearchResults();
            n = iEntryArray.length;
            n2 = 0;
            while (n2 < n) {
                IEntry searchResult = iEntryArray[n2];
                entriesSet.add(searchResult.getEntry());
                ++n2;
            }
            iEntryArray = this.getSelectedBookmarks();
            n = iEntryArray.length;
            n2 = 0;
            while (n2 < n) {
                IEntry bookmark = iEntryArray[n2];
                entriesSet.add(bookmark.getEntry());
                ++n2;
            }
            return entriesSet.toArray(new IEntry[entriesSet.size()]);
        }
        return null;
    }

    private ISearch[] getSearches() {
        if (this.getSelectedConnections().length + this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length + this.getSelectedAttributeHierarchies().length + this.getSelectedAttributes().length + this.getSelectedValues().length == 0 && this.getSelectedSearches().length > 0) {
            LinkedHashSet<ISearch> searchesSet = new LinkedHashSet<ISearch>();
            ISearch[] iSearchArray = this.getSelectedSearches();
            int n = iSearchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISearch search = iSearchArray[n2];
                searchesSet.add(search);
                ++n2;
            }
            return searchesSet.toArray(new ISearch[searchesSet.size()]);
        }
        return null;
    }

    private IValue[] getValues() {
        if (this.getSelectedConnections().length + this.getSelectedBookmarks().length + this.getSelectedEntries().length + this.getSelectedSearches().length == 0 && this.getSelectedAttributeHierarchies().length + this.getSelectedAttributes().length + this.getSelectedValues().length > 0) {
            LinkedHashSet<Object> valuesSet = new LinkedHashSet<Object>();
            AttributeHierarchy[] attributeHierarchyArray = this.getSelectedAttributeHierarchies();
            int n = attributeHierarchyArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeHierarchy ah = attributeHierarchyArray[n2];
                IAttribute[] iAttributeArray = ah.getAttributes();
                int n3 = iAttributeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAttribute attribute = iAttributeArray[n4];
                    valuesSet.addAll(Arrays.asList(attribute.getValues()));
                    ++n4;
                }
                ++n2;
            }
            attributeHierarchyArray = this.getSelectedAttributes();
            n = attributeHierarchyArray.length;
            n2 = 0;
            while (n2 < n) {
                AttributeHierarchy attribute = attributeHierarchyArray[n2];
                valuesSet.addAll(Arrays.asList(attribute.getValues()));
                ++n2;
            }
            attributeHierarchyArray = this.getSelectedValues();
            n = attributeHierarchyArray.length;
            n2 = 0;
            while (n2 < n) {
                AttributeHierarchy value = attributeHierarchyArray[n2];
                valuesSet.add(value);
                ++n2;
            }
            return valuesSet.toArray(new IValue[valuesSet.size()]);
        }
        return null;
    }
}

