/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.encoder;

import org.apache.directory.api.util.Strings;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.mina.core.buffer.IoBuffer;

public class QuestionRecordEncoder {
    public void put(IoBuffer out, QuestionRecord question) {
        this.encodeDomainName(out, question.getDomainName());
        this.encodeRecordType(out, question.getRecordType());
        this.encodeRecordClass(out, question.getRecordClass());
    }

    private void encodeDomainName(IoBuffer byteBuffer, String domainName) {
        if (!Strings.isEmpty((String)domainName)) {
            String[] labels;
            for (String label : labels = domainName.split("\\.")) {
                char[] characters;
                byteBuffer.put((byte)label.length());
                for (char c : characters = label.toCharArray()) {
                    byteBuffer.put((byte)c);
                }
            }
        }
        byteBuffer.put((byte)0);
    }

    private void encodeRecordType(IoBuffer byteBuffer, RecordType recordType) {
        byteBuffer.putShort(recordType.convert().shortValue());
    }

    private void encodeRecordClass(IoBuffer byteBuffer, RecordClass recordClass) {
        byteBuffer.putShort(recordClass.convert().shortValue());
    }
}

