/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.frequencies.FrequentItemsSketch;
import org.apache.datasketches.frequencies.FrequentLongsSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerDeCompatibilityTest {
    static final ArrayOfItemsSerDe<Long> serDe = new ArrayOfLongsSerDe();

    @Test
    public void itemsToLongs() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        sketch1.update((Object)1L);
        sketch1.update((Object)2L);
        sketch1.update((Object)3L);
        sketch1.update((Object)4L);
        byte[] bytes = sketch1.toByteArray(serDe);
        FrequentLongsSketch sketch2 = FrequentLongsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes));
        sketch2.update(2L);
        sketch2.update(3L);
        sketch2.update(2L);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate(1L), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate(2L), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate(3L), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate(4L), (long)1L);
    }

    @Test
    public void longsToItems() {
        FrequentLongsSketch sketch1 = new FrequentLongsSketch(8);
        sketch1.update(1L);
        sketch1.update(2L);
        sketch1.update(3L);
        sketch1.update(4L);
        byte[] bytes = sketch1.toByteArray();
        FrequentItemsSketch sketch2 = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), serDe);
        sketch2.update((Object)2L);
        sketch2.update((Object)3L);
        sketch2.update((Object)2L);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)1L), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)2L), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)3L), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)4L), (long)1L);
    }
}

