/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.function.Predicate;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Prints the headers of all sent and/or received messages")
public class HDRS
extends Protocol {
    @Property(description="Enables printing of down messages")
    protected volatile boolean print_down = true;
    @Property(description="Enables printing of up (received) messages")
    protected volatile boolean print_up = true;
    protected Predicate<Message> filter;

    public boolean printUp() {
        return this.print_up;
    }

    public HDRS printUp(boolean b) {
        this.print_up = b;
        return this;
    }

    public boolean printDown() {
        return this.print_down;
    }

    public HDRS printDown(boolean b) {
        this.print_down = b;
        return this;
    }

    public HDRS filter(Predicate<Message> f) {
        this.filter = f;
        return this;
    }

    @Override
    public Object down(Message msg) {
        if (this.print_down) {
            if (this.filter != null && !this.filter.test(msg)) {
                return this.down_prot.down(msg);
            }
            System.out.printf("-- to %s (%d bytes): %s\n", msg.getDest(), msg.getLength(), msg.printHeaders());
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        if (this.print_up) {
            if (this.filter != null && !this.filter.test(msg)) {
                return this.up_prot.up(msg);
            }
            System.out.printf("-- from %s (%d bytes): %s\n", msg.getSrc(), msg.getLength(), msg.printHeaders());
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.print_up) {
            if (this.filter != null && !batch.anyMatch(this.filter)) {
                this.up_prot.up(batch);
                return;
            }
            for (Message msg : batch) {
                System.out.printf("-- from %s (%d bytes): %s\n", msg.getSrc(), msg.getLength(), msg.printHeaders());
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }
}

