/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConcurrentDirectDeque;
import io.undertow.util.WorkerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;

public class InMemorySessionManager
implements SessionManager,
SessionManagerStatistics {
    private final AttachmentKey<SessionImpl> NEW_SESSION = AttachmentKey.create(SessionImpl.class);
    private final SessionIdGenerator sessionIdGenerator;
    private final ConcurrentMap<String, SessionImpl> sessions;
    private final SessionListeners sessionListeners = new SessionListeners();
    private volatile int defaultSessionTimeout = 1800;
    private final int maxSize;
    private final ConcurrentDirectDeque<String> evictionQueue;
    private final String deploymentName;
    private final AtomicLong createdSessionCount = new AtomicLong();
    private final AtomicLong rejectedSessionCount = new AtomicLong();
    private volatile long longestSessionLifetime = 0L;
    private volatile long expiredSessionCount = 0L;
    private volatile BigInteger totalSessionLifetime = BigInteger.ZERO;
    private final AtomicInteger highestSessionCount = new AtomicInteger();
    private final boolean statisticsEnabled;
    private volatile long startTime;
    private final boolean expireOldestUnusedSessionOnMax;

    public InMemorySessionManager(String deploymentName, int maxSessions, boolean expireOldestUnusedSessionOnMax) {
        this(new SecureRandomSessionIdGenerator(), deploymentName, maxSessions, expireOldestUnusedSessionOnMax);
    }

    public InMemorySessionManager(SessionIdGenerator sessionIdGenerator, String deploymentName, int maxSessions, boolean expireOldestUnusedSessionOnMax) {
        this(sessionIdGenerator, deploymentName, maxSessions, expireOldestUnusedSessionOnMax, true);
    }

    public InMemorySessionManager(SessionIdGenerator sessionIdGenerator, String deploymentName, int maxSessions, boolean expireOldestUnusedSessionOnMax, boolean statisticsEnabled) {
        this.sessionIdGenerator = sessionIdGenerator;
        this.deploymentName = deploymentName;
        this.statisticsEnabled = statisticsEnabled;
        this.expireOldestUnusedSessionOnMax = expireOldestUnusedSessionOnMax;
        this.sessions = new ConcurrentHashMap<String, SessionImpl>();
        this.maxSize = maxSessions;
        ConcurrentDirectDeque evictionQueue = null;
        if (maxSessions > 0 && expireOldestUnusedSessionOnMax) {
            evictionQueue = ConcurrentDirectDeque.newInstance();
        }
        this.evictionQueue = evictionQueue;
    }

    public InMemorySessionManager(String deploymentName, int maxSessions) {
        this(deploymentName, maxSessions, false);
    }

    public InMemorySessionManager(String id) {
        this(id, -1);
    }

    @Override
    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Override
    public void start() {
        this.createdSessionCount.set(0L);
        this.expiredSessionCount = 0L;
        this.rejectedSessionCount.set(0L);
        this.totalSessionLifetime = BigInteger.ZERO;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void stop() {
        for (Map.Entry session : this.sessions.entrySet()) {
            SessionImpl sessionValue = (SessionImpl)session.getValue();
            sessionValue.destroy();
            if (sessionValue.getId() == null) {
                sessionValue.setId((String)session.getKey());
            }
            this.sessionListeners.sessionDestroyed((Session)session.getValue(), null, SessionListener.SessionDestroyedReason.UNDEPLOY);
        }
        this.sessions.clear();
    }

    @Override
    public Session createSession(HttpServerExchange serverExchange, SessionConfig config) {
        if (this.maxSize > 0) {
            if (this.expireOldestUnusedSessionOnMax) {
                String key;
                while (this.sessions.size() >= this.maxSize && !this.evictionQueue.isEmpty() && (key = (String)this.evictionQueue.poll()) != null) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Removing session %s as max size has been hit", key);
                    SessionImpl toRemove = (SessionImpl)this.sessions.get(key);
                    if (toRemove == null) continue;
                    toRemove.invalidate(null, SessionListener.SessionDestroyedReason.TIMEOUT);
                }
            } else if (this.sessions.size() >= this.maxSize) {
                if (this.statisticsEnabled) {
                    this.rejectedSessionCount.incrementAndGet();
                }
                throw UndertowMessages.MESSAGES.tooManySessions(this.maxSize);
            }
        }
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String sessionID = config.findSessionId(serverExchange);
        SessionImpl session = new SessionImpl(this, config, serverExchange.getIoThread(), serverExchange.getConnection().getWorker(), this.defaultSessionTimeout);
        if (sessionID != null) {
            if (!this.saveSessionID(sessionID, session)) {
                session.destroy();
                throw UndertowMessages.MESSAGES.sessionWithIdAlreadyExists(sessionID);
            }
        } else {
            sessionID = this.createAndSaveNewID(session);
        }
        session.setId(sessionID);
        if (this.evictionQueue != null) {
            session.setEvictionToken(this.evictionQueue.offerLastAndReturnToken(sessionID));
        }
        UndertowLogger.SESSION_LOGGER.debugf("Created session with id %s for exchange %s", sessionID, serverExchange);
        config.setSessionId(serverExchange, session.getId());
        session.bumpTimeout();
        this.sessionListeners.sessionCreated(session, serverExchange);
        serverExchange.putAttachment(this.NEW_SESSION, session);
        if (this.statisticsEnabled) {
            int highest;
            int sessionSize;
            this.createdSessionCount.incrementAndGet();
            do {
                highest = this.highestSessionCount.get();
            } while ((sessionSize = this.sessions.size()) > highest && !this.highestSessionCount.compareAndSet(highest, sessionSize));
        }
        return session;
    }

    private boolean saveSessionID(String sessionID, SessionImpl session) {
        return this.sessions.putIfAbsent(sessionID, session) == null;
    }

    private String createAndSaveNewID(SessionImpl session) {
        for (int i = 0; i < 100; ++i) {
            String sessionID = this.sessionIdGenerator.createSessionId();
            if (!this.saveSessionID(sessionID, session)) continue;
            return sessionID;
        }
        throw UndertowMessages.MESSAGES.couldNotGenerateUniqueSessionId();
    }

    @Override
    public Session getSession(HttpServerExchange serverExchange, SessionConfig config) {
        SessionImpl newSession;
        if (serverExchange != null && (newSession = serverExchange.getAttachment(this.NEW_SESSION)) != null) {
            return newSession;
        }
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String sessionId = config.findSessionId(serverExchange);
        SessionImpl session = (SessionImpl)this.getSession(sessionId);
        if (session != null && serverExchange != null) {
            session.requestStarted(serverExchange);
        }
        return session;
    }

    @Override
    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        SessionImpl sess = (SessionImpl)this.sessions.get(sessionId);
        if (sess == null) {
            return null;
        }
        if (sess.getId() == null) {
            sess.setId(sessionId);
        }
        return sess;
    }

    @Override
    public synchronized void registerSessionListener(SessionListener listener) {
        UndertowLogger.SESSION_LOGGER.debugf("Registered session listener %s", listener);
        this.sessionListeners.addSessionListener(listener);
    }

    @Override
    public synchronized void removeSessionListener(SessionListener listener) {
        UndertowLogger.SESSION_LOGGER.debugf("Removed session listener %s", listener);
        this.sessionListeners.removeSessionListener(listener);
    }

    @Override
    public void setDefaultSessionTimeout(int timeout) {
        UndertowLogger.SESSION_LOGGER.debugf("Setting default session timeout to %s", timeout);
        this.defaultSessionTimeout = timeout;
    }

    @Override
    public Set<String> getTransientSessions() {
        return this.getAllSessions();
    }

    @Override
    public Set<String> getActiveSessions() {
        return this.getAllSessions();
    }

    @Override
    public Set<String> getAllSessions() {
        return new HashSet<String>(this.sessions.keySet());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionManager)) {
            return false;
        }
        SessionManager manager = (SessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }

    @Override
    public SessionManagerStatistics getStatistics() {
        return this;
    }

    @Override
    public long getCreatedSessionCount() {
        return this.createdSessionCount.get();
    }

    @Override
    public long getMaxActiveSessions() {
        return this.maxSize;
    }

    @Override
    public long getHighestSessionCount() {
        return this.highestSessionCount.get();
    }

    @Override
    public long getActiveSessionCount() {
        return this.sessions.size();
    }

    @Override
    public long getExpiredSessionCount() {
        return this.expiredSessionCount;
    }

    @Override
    public long getRejectedSessions() {
        return this.rejectedSessionCount.get();
    }

    @Override
    public long getMaxSessionAliveTime() {
        return this.longestSessionLifetime;
    }

    @Override
    public synchronized long getAverageSessionAliveTime() {
        if (this.expiredSessionCount == 0L) {
            return 0L;
        }
        return new BigDecimal(this.totalSessionLifetime).divide(BigDecimal.valueOf(this.expiredSessionCount), MathContext.DECIMAL128).longValue();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    private static class SessionImpl
    implements Session {
        final AttachmentKey<Long> FIRST_REQUEST_ACCESS = AttachmentKey.create(Long.class);
        final InMemorySessionManager sessionManager;
        final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        volatile long lastAccessed;
        final long creationTime;
        volatile int maxInactiveInterval;
        static volatile AtomicReferenceFieldUpdater<SessionImpl, Object> evictionTokenUpdater = AccessController.doPrivileged(new PrivilegedAction<AtomicReferenceFieldUpdater<SessionImpl, Object>>(){

            @Override
            public AtomicReferenceFieldUpdater<SessionImpl, Object> run() {
                return SessionImpl.createTokenUpdater();
            }
        });
        private volatile String sessionId;
        private volatile Object evictionToken;
        private final SessionConfig sessionCookieConfig;
        private volatile long expireTime = -1L;
        private volatile boolean invalid = false;
        private volatile boolean invalidationStarted = false;
        final XnioIoThread executor;
        final XnioWorker worker;
        XnioExecutor.Key timerCancelKey;
        Runnable cancelTask = new Runnable(){

            @Override
            public void run() {
                worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime >= expireTime) {
                            this.invalidate(null, SessionListener.SessionDestroyedReason.TIMEOUT);
                        } else {
                            timerCancelKey = WorkerUtils.executeAfter(executor, cancelTask, expireTime - currentTime, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        };

        private static AtomicReferenceFieldUpdater<SessionImpl, Object> createTokenUpdater() {
            return AtomicReferenceFieldUpdater.newUpdater(SessionImpl.class, Object.class, "evictionToken");
        }

        private SessionImpl(InMemorySessionManager sessionManager, SessionConfig sessionCookieConfig, XnioIoThread executor, XnioWorker worker, int maxInactiveInterval) {
            this.sessionManager = sessionManager;
            this.sessionCookieConfig = sessionCookieConfig;
            this.executor = executor;
            this.worker = worker;
            this.creationTime = this.lastAccessed = System.currentTimeMillis();
            this.setMaxInactiveInterval(maxInactiveInterval);
        }

        synchronized void bumpTimeout() {
            if (this.invalidationStarted) {
                return;
            }
            long maxInactiveInterval = this.getMaxInactiveIntervalMilis();
            if (maxInactiveInterval > 0L) {
                long newExpireTime = System.currentTimeMillis() + maxInactiveInterval;
                if (this.timerCancelKey != null && newExpireTime < this.expireTime) {
                    if (!this.timerCancelKey.remove()) {
                        return;
                    }
                    this.timerCancelKey = null;
                }
                this.expireTime = newExpireTime;
                UndertowLogger.SESSION_LOGGER.tracef("Bumping timeout for session %s to %s", this.sessionId, this.expireTime);
                if (this.timerCancelKey == null) {
                    this.timerCancelKey = this.executor.executeAfter(this.cancelTask, maxInactiveInterval + 1L, TimeUnit.MILLISECONDS);
                }
            } else {
                this.expireTime = -1L;
                if (this.timerCancelKey != null) {
                    this.timerCancelKey.remove();
                    this.timerCancelKey = null;
                }
            }
        }

        private void setEvictionToken(Object evictionToken) {
            Object token;
            this.evictionToken = evictionToken;
            if (evictionToken != null && evictionTokenUpdater.compareAndSet(this, token = evictionToken, null)) {
                this.sessionManager.evictionQueue.removeToken(token);
                this.evictionToken = this.sessionManager.evictionQueue.offerLastAndReturnToken(this.sessionId);
            }
        }

        private void setId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public String getId() {
            return this.sessionId;
        }

        void requestStarted(HttpServerExchange serverExchange) {
            Long existing = serverExchange.getAttachment(this.FIRST_REQUEST_ACCESS);
            if (existing == null && !this.invalid) {
                serverExchange.putAttachment(this.FIRST_REQUEST_ACCESS, System.currentTimeMillis());
            }
            this.bumpTimeout();
        }

        @Override
        public void requestDone(HttpServerExchange serverExchange) {
            Long existing = serverExchange.getAttachment(this.FIRST_REQUEST_ACCESS);
            if (existing != null) {
                this.lastAccessed = existing;
            }
            this.bumpTimeout();
        }

        @Override
        public long getCreationTime() {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            return this.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            return this.lastAccessed;
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            UndertowLogger.SESSION_LOGGER.debugf("Setting max inactive interval for %s to %s", this.sessionId, interval);
            this.maxInactiveInterval = interval;
            this.bumpTimeout();
        }

        @Override
        public int getMaxInactiveInterval() {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            return this.maxInactiveInterval;
        }

        private long getMaxInactiveIntervalMilis() {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            return (long)this.maxInactiveInterval * 1000L;
        }

        @Override
        public Object getAttribute(String name) {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            return this.attributes.get(name);
        }

        @Override
        public Set<String> getAttributeNames() {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            return this.attributes.keySet();
        }

        @Override
        public Object setAttribute(String name, Object value) {
            if (value == null) {
                return this.removeAttribute(name);
            }
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            Object existing = this.attributes.put(name, value);
            if (existing == null) {
                this.sessionManager.sessionListeners.attributeAdded(this, name, value);
            } else {
                this.sessionManager.sessionListeners.attributeUpdated(this, name, value, existing);
            }
            UndertowLogger.SESSION_LOGGER.tracef("Setting session attribute %s to %s for session %s", name, value, this.sessionId);
            return existing;
        }

        @Override
        public Object removeAttribute(String name) {
            if (this.invalid) {
                throw UndertowMessages.MESSAGES.sessionIsInvalid(this.sessionId);
            }
            Object existing = this.attributes.remove(name);
            this.sessionManager.sessionListeners.attributeRemoved(this, name, existing);
            UndertowLogger.SESSION_LOGGER.tracef("Removing session attribute %s for session %s", name, this.sessionId);
            return existing;
        }

        @Override
        public void invalidate(HttpServerExchange exchange) {
            Object evictionToken;
            this.invalidate(exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
            if (exchange != null) {
                exchange.removeAttachment(this.sessionManager.NEW_SESSION);
            }
            if ((evictionToken = this.evictionToken) != null) {
                this.sessionManager.evictionQueue.removeToken(evictionToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate(HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            SessionImpl sessionImpl = this;
            synchronized (sessionImpl) {
                SessionImpl sess;
                if (this.timerCancelKey != null) {
                    this.timerCancelKey.remove();
                }
                if ((sess = (SessionImpl)this.sessionManager.sessions.remove(this.sessionId)) == null) {
                    if (reason == SessionListener.SessionDestroyedReason.INVALIDATED) {
                        throw UndertowMessages.MESSAGES.sessionAlreadyInvalidated();
                    }
                    return;
                }
                this.invalidationStarted = true;
            }
            UndertowLogger.SESSION_LOGGER.debugf("Invalidating session %s for exchange %s", this.sessionId, exchange);
            this.sessionManager.sessionListeners.sessionDestroyed(this, exchange, reason);
            this.invalid = true;
            if (this.sessionManager.statisticsEnabled) {
                long life = System.currentTimeMillis() - this.creationTime;
                InMemorySessionManager inMemorySessionManager = this.sessionManager;
                synchronized (inMemorySessionManager) {
                    this.sessionManager.expiredSessionCount++;
                    this.sessionManager.totalSessionLifetime = this.sessionManager.totalSessionLifetime.add(BigInteger.valueOf(life));
                    if (this.sessionManager.longestSessionLifetime < life) {
                        this.sessionManager.longestSessionLifetime = life;
                    }
                }
            }
            if (exchange != null) {
                this.sessionCookieConfig.clearSession(exchange, this.getId());
            }
        }

        @Override
        public SessionManager getSessionManager() {
            return this.sessionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
            SessionImpl sessionImpl = this;
            synchronized (sessionImpl) {
                String newId;
                if (this.invalidationStarted) {
                    return null;
                }
                String oldId = this.sessionId;
                this.sessionId = newId = this.sessionManager.createAndSaveNewID(this);
                config.setSessionId(exchange, this.getId());
                this.sessionManager.sessions.remove(oldId);
                this.sessionManager.sessionListeners.sessionIdChanged(this, oldId);
                UndertowLogger.SESSION_LOGGER.debugf("Changing session id %s to %s", oldId, newId);
                return newId;
            }
        }

        private synchronized void destroy() {
            if (this.timerCancelKey != null) {
                this.timerCancelKey.remove();
            }
            this.cancelTask = null;
        }
    }
}

