/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FieldTest {
    protected Field field;

    FieldTest() {
    }

    private Arg createArg(String key) {
        Arg arg = new Arg();
        arg.setKey(key);
        return arg;
    }

    private Arg createArg(String key, int position) {
        Arg arg = this.createArg(key);
        arg.setPosition(position);
        return arg;
    }

    private Arg createArg(String key, String name) {
        Arg arg = this.createArg(key);
        arg.setName(name);
        return arg;
    }

    private Arg createArg(String key, String name, int position) {
        Arg arg = this.createArg(key, name);
        arg.setPosition(position);
        return arg;
    }

    @BeforeEach
    public void setUp() {
        this.field = new Field();
    }

    @AfterEach
    public void tearDown() {
        this.field = null;
    }

    @Test
    void testDefaultOnePosition() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-2", 2));
        this.field.addArg(this.createArg("default-position-3"));
        Assertions.assertEquals((int)4, (int)this.field.getArgs("required").length, (String)"testDefaultOnePosition(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testDefaultOnePosition(2) ");
        Assertions.assertNull((Object)this.field.getArg("required", 1), (String)"testDefaultOnePosition(3) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testDefaultOnePosition(4) ");
        Assertions.assertEquals((Object)"default-position-3", (Object)this.field.getArg("required", 3).getKey(), (String)"testDefaultOnePosition(5) ");
    }

    @Test
    void testDefaultPositionImplied() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        Assertions.assertEquals((int)3, (int)this.field.getArgs("required").length, (String)"testDefaultPositionImplied(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testDefaultPositionImplied(2) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testDefaultPositionImplied(3) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testDefaultPositionImplied(4) ");
    }

    @Test
    void testDefaultSomePositions() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-2", 2));
        this.field.addArg(this.createArg("default-position-3"));
        this.field.addArg(this.createArg("default-position-1", 1));
        Assertions.assertEquals((int)4, (int)this.field.getArgs("required").length, (String)"testDefaultSomePositions(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testDefaultSomePositions(2) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testDefaultSomePositions(3) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testDefaultSomePositions(4) ");
        Assertions.assertEquals((Object)"default-position-3", (Object)this.field.getArg("required", 3).getKey(), (String)"testDefaultSomePositions(5) ");
    }

    @Test
    void testDefaultUsingPositions() {
        this.field.addArg(this.createArg("default-position-1", 1));
        this.field.addArg(this.createArg("default-position-0", 0));
        this.field.addArg(this.createArg("default-position-2", 2));
        Assertions.assertEquals((int)3, (int)this.field.getArgs("required").length, (String)"testDefaultUsingPositions(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testDefaultUsingPositions(2) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testDefaultUsingPositions(3) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testDefaultUsingPositions(4) ");
    }

    @Test
    void testEmptyArgs() {
        Assertions.assertEquals((int)0, (int)this.field.getArgs("required").length, (String)"Empty Args(1) ");
    }

    @Test
    void testOverridePositionImplied() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("required-position-1", "required"));
        this.field.addArg(this.createArg("required-position-2", "required"));
        this.field.addArg(this.createArg("mask-position-1", "mask"));
        Assertions.assertEquals((int)3, (int)this.field.getArgs("required").length, (String)"testOverridePositionImplied(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testOverridePositionImplied(2) ");
        Assertions.assertEquals((Object)"required-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testOverridePositionImplied(3) ");
        Assertions.assertEquals((Object)"required-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testOverridePositionImplied(4) ");
        Assertions.assertEquals((int)3, (int)this.field.getArgs("mask").length, (String)"testOverridePositionImplied(5) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("mask", 0).getKey(), (String)"testOverridePositionImplied(6) ");
        Assertions.assertEquals((Object)"mask-position-1", (Object)this.field.getArg("mask", 1).getKey(), (String)"testOverridePositionImplied(7) ");
        Assertions.assertNull((Object)this.field.getArg("mask", 2), (String)"testOverridePositionImplied(8) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg(0).getKey(), (String)"testOverridePositionImplied(9) ");
        Assertions.assertNull((Object)this.field.getArg(1), (String)"testOverridePositionImplied(10) ");
        Assertions.assertNull((Object)this.field.getArg(2), (String)"testOverridePositionImplied(11) ");
    }

    @Test
    void testOverrideSomePosition() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        this.field.addArg(this.createArg("required-position-1", "required", 1));
        this.field.addArg(this.createArg("required-position-2", "required"));
        this.field.addArg(this.createArg("mask-position-3", "mask"));
        Assertions.assertEquals((int)4, (int)this.field.getArgs("required").length, (String)"testOverrideSomePosition(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testOverrideSomePosition(2) ");
        Assertions.assertEquals((Object)"required-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testOverrideSomePosition(3) ");
        Assertions.assertEquals((Object)"required-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testOverrideSomePosition(4) ");
        Assertions.assertNull((Object)this.field.getArg("required", 3), (String)"testOverrideSomePosition(5) ");
        Assertions.assertEquals((int)4, (int)this.field.getArgs("mask").length, (String)"testOverrideSomePosition(6) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("mask", 0).getKey(), (String)"testOverrideSomePosition(7) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg("mask", 1).getKey(), (String)"testOverrideSomePosition(8) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("mask", 2).getKey(), (String)"testOverrideSomePosition(9) ");
        Assertions.assertEquals((Object)"mask-position-3", (Object)this.field.getArg("mask", 3).getKey(), (String)"testOverrideSomePosition(10) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg(0).getKey(), (String)"testOverrideSomePosition(11) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg(1).getKey(), (String)"testOverrideSomePosition(12) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg(2).getKey(), (String)"testOverrideSomePosition(13) ");
        Assertions.assertNull((Object)this.field.getArg(3), (String)"testOverrideSomePosition(14) ");
    }

    @Test
    void testOverrideUsingPositionA() {
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        this.field.addArg(this.createArg("required-position-1", "required", 1));
        Assertions.assertEquals((int)3, (int)this.field.getArgs("required").length, (String)"testOverrideUsingPositionA(1) ");
        Assertions.assertEquals((Object)"required-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testOverrideUsingPositionA(2) ");
        Assertions.assertEquals((int)3, (int)this.field.getArgs("mask").length, (String)"testOverrideUsingPositionA(3) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg("mask", 1).getKey(), (String)"testOverrideUsingPositionA(4) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg(1).getKey(), (String)"testOverrideUsingPositionA(5) ");
    }

    @Test
    void testOverrideUsingPositionB() {
        this.field.addArg(this.createArg("required-position-3", "required", 3));
        this.field.addArg(this.createArg("required-position-1", "required", 1));
        this.field.addArg(this.createArg("default-position-0"));
        this.field.addArg(this.createArg("default-position-1"));
        this.field.addArg(this.createArg("default-position-2"));
        Assertions.assertEquals((int)4, (int)this.field.getArgs("required").length, (String)"testOverrideUsingPositionB(1) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("required", 0).getKey(), (String)"testOverrideUsingPositionB(2) ");
        Assertions.assertEquals((Object)"required-position-1", (Object)this.field.getArg("required", 1).getKey(), (String)"testOverrideUsingPositionB(3) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("required", 2).getKey(), (String)"testOverrideUsingPositionB(4) ");
        Assertions.assertEquals((Object)"required-position-3", (Object)this.field.getArg("required", 3).getKey(), (String)"testOverrideUsingPositionB(5) ");
        Assertions.assertEquals((int)4, (int)this.field.getArgs("mask").length, (String)"testOverrideUsingPositionB(6) ");
        Assertions.assertEquals((Object)"default-position-0", (Object)this.field.getArg("mask", 0).getKey(), (String)"testOverrideUsingPositionB(6) ");
        Assertions.assertEquals((Object)"default-position-1", (Object)this.field.getArg("mask", 1).getKey(), (String)"testOverrideUsingPositionB(7) ");
        Assertions.assertEquals((Object)"default-position-2", (Object)this.field.getArg("mask", 2).getKey(), (String)"testOverrideUsingPositionB(8) ");
        Assertions.assertNull((Object)this.field.getArg("mask", 3), (String)"testOverrideUsingPositionB(9) ");
    }
}

