/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import org.apache.commons.text.lookup.ConstantStringLookup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ConstantStringLookupBasicTest {
    public static final String NULL_STRING_FIXTURE = null;
    public static final String STRING_FIXTURE = "Hello World!";

    ConstantStringLookupBasicTest() {
    }

    @AfterEach
    public void afterEach() {
        ConstantStringLookup.clear();
    }

    @BeforeEach
    public void beforeEach() {
        ConstantStringLookup.clear();
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)ConstantStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testNullClassFetch() {
        Assertions.assertNull((Object)new ConstantStringLookup(){

            protected Class<?> fetchClass(String className) throws ClassNotFoundException {
                return null;
            }
        }.apply(ConstantStringLookupBasicTest.class.getName() + ".STRING_FIXTURE"));
    }

    @Test
    void testNullValue() {
        Assertions.assertEquals((Object)NULL_STRING_FIXTURE, (Object)ConstantStringLookup.INSTANCE.apply(ConstantStringLookupBasicTest.class.getName() + ".NULL_STRING_FIXTURE"));
    }

    @Test
    void testOne() {
        Assertions.assertEquals((Object)STRING_FIXTURE, (Object)ConstantStringLookup.INSTANCE.apply(ConstantStringLookupBasicTest.class.getName() + ".STRING_FIXTURE"));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)ConstantStringLookup.INSTANCE.toString().isEmpty());
    }
}

