/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache.invalidation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.cache.invalidation.CacheGroup;
import org.apache.cayenne.cache.invalidation.CacheGroupDescriptor;
import org.apache.cayenne.cache.invalidation.CacheGroups;
import org.apache.cayenne.cache.invalidation.InvalidationHandler;

public class CacheGroupsHandler
implements InvalidationHandler {
    @Override
    public Function<Persistent, Collection<CacheGroupDescriptor>> canHandle(Class<? extends Persistent> type) {
        CacheGroup multipleCacheGroups = type.getAnnotation(CacheGroup.class);
        CacheGroups cacheGroups = type.getAnnotation(CacheGroups.class);
        if (cacheGroups == null && multipleCacheGroups == null) {
            return null;
        }
        ArrayList<CacheGroupDescriptor> groupsList = new ArrayList<CacheGroupDescriptor>();
        this.extractCacheGroups(cacheGroups, groupsList);
        this.extractCacheGroups(multipleCacheGroups, groupsList);
        return p -> groupsList;
    }

    private void extractCacheGroups(CacheGroup cacheGroup, Collection<CacheGroupDescriptor> groupsList) {
        if (cacheGroup == null) {
            return;
        }
        groupsList.add(new CacheGroupDescriptor(cacheGroup.value(), cacheGroup.keyType(), cacheGroup.valueType()));
    }

    private void extractCacheGroups(CacheGroups cacheGroups, Collection<CacheGroupDescriptor> groupsList) {
        if (cacheGroups == null) {
            return;
        }
        for (String name : cacheGroups.value()) {
            groupsList.add(new CacheGroupDescriptor(name));
        }
        for (CacheGroup group : cacheGroups.groups()) {
            this.extractCacheGroups(group, groupsList);
        }
    }
}

