/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.MatchType;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class Matcher {
    private final Map<String, String> exactMatches;
    private final Map.Entry<Pattern, String>[] regexMatches;
    private final Map<String, String> aliases = new HashMap<String, String>();

    Matcher(List<Match> matches) {
        for (Match match2 : matches) {
            if (match2.getAlias() == null) continue;
            this.aliases.put(match2.getValue(), match2.getAlias());
        }
        this.exactMatches = matches.stream().filter(match -> match.getType() == MatchType.EQUALS && match.getValue() != null).collect(Collectors.toMap(Match::getValue, match -> match.getAlias() != null ? match.getAlias() : match.getValue()));
        Map.Entry[] entries = (Map.Entry[])matches.stream().filter(match -> match.getType() == MatchType.REGEX && match.getValue() != null).map(match -> new AbstractMap.SimpleEntry<Pattern, String>(Pattern.compile(match.getValue()), match.getAlias())).toArray(Map.Entry[]::new);
        this.regexMatches = entries;
    }

    String matches(String value) {
        String valueOrAlias;
        if (this.exactMatches.size() > 0 && this.exactMatches.containsKey(value) && (valueOrAlias = this.exactMatches.get(value)) != null) {
            return valueOrAlias;
        }
        if (this.regexMatches.length > 0) {
            for (Map.Entry<Pattern, String> entry : this.regexMatches) {
                if (!entry.getKey().matcher(value).matches()) continue;
                String alias = entry.getValue();
                if (alias != null) {
                    return alias;
                }
                return value;
            }
        }
        return null;
    }
}

