/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.dropwizard.impl.HttpMetricsImpl;

class HttpClientReporter
extends HttpMetricsImpl {
    int totalMaxPoolSize;

    public HttpClientReporter(MetricRegistry registry, String baseName, SocketAddress localAdress) {
        super(registry, baseName, localAdress);
        this.gauge(() -> this.totalMaxPoolSize, "connections", "max-pool-size");
        RatioGauge gauge = new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)HttpClientReporter.this.connections(), (double)HttpClientReporter.this.totalMaxPoolSize);
            }
        };
        this.gauge(gauge, new String[]{"connections", "pool-ratio"});
    }

    void incMaxPoolSize(int maxPoolSize) {
        this.totalMaxPoolSize += maxPoolSize;
    }

    boolean decMaxPoolSize(int maxPoolSize) {
        this.totalMaxPoolSize -= maxPoolSize;
        return this.totalMaxPoolSize == 0;
    }
}

